/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlan;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlanBuilder;
import org.gradle.api.plugins.antlr.internal.antlr2.MetadataExtracter;
import org.gradle.api.plugins.antlr.internal.antlr2.XRef;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntlrExecuter.class);

    AntlrResult runAntlr(AntlrSpec spec) throws IOException, InterruptedException {
        String[] commandLine = this.toArray(spec.asCommandLineWithFiles());
        try {
            Object toolObj = this.loadTool("org.antlr.v4.Tool", commandLine);
            LOGGER.info("Processing with ANTLR 4");
            return this.processV4(toolObj);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("ANTLR 4 not found on classpath");
            try {
                Object toolObj = this.loadTool("org.antlr.Tool", commandLine);
                LOGGER.info("Processing with ANTLR 3");
                return this.processV3(toolObj);
            }
            catch (ClassNotFoundException e2) {
                LOGGER.debug("ANTLR 3 not found on classpath");
                try {
                    Object toolObj = this.loadTool("antlr.Tool", null);
                    LOGGER.info("Processing with ANTLR 2");
                    return this.processV2(toolObj, spec.asCommandLineWithoutFiles(), spec.getGrammarFiles(), spec.getOutputDirectory());
                }
                catch (ClassNotFoundException e3) {
                    LOGGER.debug("ANTLR 2 not found on classpath");
                    throw new IllegalStateException("No Antlr implementation available");
                }
            }
        }
    }

    private String[] toArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    Object loadTool(String className, String[] args) throws ClassNotFoundException {
        try {
            Class<?> toolClass = Class.forName(className);
            if (args == null) {
                return toolClass.newInstance();
            }
            Constructor<?> constructor = toolClass.getConstructor(String[].class);
            return constructor.newInstance(new Object[]{args});
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new GradleException("Failed to load ANTLR", e.getCause());
        }
        catch (Exception e) {
            throw new GradleException("Failed to load ANTLR", (Throwable)e);
        }
    }

    AntlrResult processV2(Object tool, List<String> arguments, Set<File> grammarFiles, File outputDirectory) {
        XRef xref = new MetadataExtracter().extractMetadata(grammarFiles);
        List<GenerationPlan> generationPlans = new GenerationPlanBuilder(outputDirectory).buildGenerationPlans(xref);
        for (GenerationPlan generationPlan : generationPlans) {
            String[] argArr = arguments.toArray(new String[arguments.size() + 1]);
            argArr[arguments.size()] = generationPlan.getSource().getAbsolutePath();
            JavaReflectionUtil.method((Object)tool, Integer.class, (String)"doEverything", (Class[])new Class[]{String[].class}).invoke(tool, new Object[]{argArr});
        }
        return new AntlrResult(0);
    }

    AntlrResult processV3(Object tool) {
        JavaReflectionUtil.method((Object)tool, Void.class, (String)"process", (Class[])new Class[0]).invoke(tool, new Object[0]);
        return new AntlrResult((Integer)JavaReflectionUtil.method((Object)tool, Integer.class, (String)"getNumErrors", (Class[])new Class[0]).invoke(tool, new Object[0]));
    }

    AntlrResult processV4(Object tool) {
        JavaReflectionUtil.method((Object)tool, Void.class, (String)"processGrammarsOnCommandLine", (Class[])new Class[0]).invoke(tool, new Object[0]);
        return new AntlrResult((Integer)JavaReflectionUtil.method((Object)tool, Integer.class, (String)"getNumErrors", (Class[])new Class[0]).invoke(tool, new Object[0]));
    }
}

