/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrSpec
implements Serializable {
    private List<String> arguments;
    private Set<File> grammarFiles;
    private String maxHeapSize;
    private File outputDirectory;

    public AntlrSpec(List<String> arguments, Set<File> grammarFiles, File outputDirectory, String maxHeapSize) {
        this.arguments = arguments;
        this.grammarFiles = grammarFiles;
        this.outputDirectory = outputDirectory;
        this.maxHeapSize = maxHeapSize;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Set<File> getGrammarFiles() {
        return this.grammarFiles;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public List<String> asCommandLineWithoutFiles() {
        LinkedList commandLine = Lists.newLinkedList(this.arguments);
        commandLine.add("-o");
        commandLine.add(this.getOutputDirectory().getAbsolutePath());
        return commandLine;
    }

    public List<String> asCommandLineWithFiles() {
        LinkedList commandLine = Lists.newLinkedList(this.asCommandLineWithoutFiles());
        for (File file : this.getGrammarFiles()) {
            commandLine.add(file.getAbsolutePath());
        }
        return commandLine;
    }
}

