/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kms.model.AliasListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAliasesResult
implements Serializable {
    private ListWithAutoConstructFlag<AliasListEntry> aliases;
    private String nextMarker;
    private Boolean truncated;

    public List<AliasListEntry> getAliases() {
        if (this.aliases == null) {
            this.aliases = new ListWithAutoConstructFlag();
            this.aliases.setAutoConstruct(true);
        }
        return this.aliases;
    }

    public void setAliases(Collection<AliasListEntry> aliases) {
        if (aliases == null) {
            this.aliases = null;
            return;
        }
        ListWithAutoConstructFlag aliasesCopy = new ListWithAutoConstructFlag(aliases.size());
        aliasesCopy.addAll(aliases);
        this.aliases = aliasesCopy;
    }

    public ListAliasesResult withAliases(AliasListEntry ... aliases) {
        if (this.getAliases() == null) {
            this.setAliases(new ArrayList<AliasListEntry>(aliases.length));
        }
        for (AliasListEntry value : aliases) {
            this.getAliases().add(value);
        }
        return this;
    }

    public ListAliasesResult withAliases(Collection<AliasListEntry> aliases) {
        if (aliases == null) {
            this.aliases = null;
        } else {
            ListWithAutoConstructFlag aliasesCopy = new ListWithAutoConstructFlag(aliases.size());
            aliasesCopy.addAll(aliases);
            this.aliases = aliasesCopy;
        }
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListAliasesResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public ListAliasesResult withTruncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAliases() != null) {
            sb.append("Aliases: " + this.getAliases() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("Truncated: " + this.isTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAliases() == null ? 0 : this.getAliases().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResult)) {
            return false;
        }
        ListAliasesResult other = (ListAliasesResult)obj;
        if (other.getAliases() == null ^ this.getAliases() == null) {
            return false;
        }
        if (other.getAliases() != null && !other.getAliases().equals(this.getAliases())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        return other.isTruncated() == null || other.isTruncated().equals(this.isTruncated());
    }
}

