/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.language.base.internal.LanguageSourceSetInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLanguageSourceSet
extends AbstractBuildableModelElement
implements LanguageSourceSetInternal {
    private final String name;
    private final String fullName;
    private final String displayName;
    private final SourceDirectorySet source;
    private boolean generated;
    private Task generatorTask;

    public AbstractLanguageSourceSet(String name, String parentName, String typeName, SourceDirectorySet source) {
        this.name = name;
        this.fullName = parentName + StringUtils.capitalize((String)name);
        this.displayName = String.format("%s '%s:%s'", typeName, parentName, name);
        this.source = source;
        super.builtBy(new Object[]{source.getBuildDependencies()});
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void builtBy(Object ... tasks) {
        this.generated = true;
        super.builtBy(tasks);
    }

    public void generatedBy(Task generatorTask) {
        this.generatorTask = generatorTask;
    }

    public Task getGeneratorTask() {
        return this.generatorTask;
    }

    public boolean getMayHaveSources() {
        return this.generated || !this.source.isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void source(Action<? super SourceDirectorySet> config) {
        config.execute((Object)this.getSource());
    }

    public SourceDirectorySet getSource() {
        return this.source;
    }
}

