/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassDirectoryBinaryNamingScheme
implements BinaryNamingScheme {
    private final String baseName;
    private final String collapsedName;

    public ClassDirectoryBinaryNamingScheme(String baseName) {
        this.baseName = baseName;
        this.collapsedName = ClassDirectoryBinaryNamingScheme.collapseMain(this.baseName);
    }

    private static String collapseMain(String name) {
        return name.equals("main") ? "" : name;
    }

    public String getDescription() {
        return String.format("classes '%s'", this.baseName);
    }

    public List<String> getVariantDimensions() {
        return Collections.emptyList();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getLifecycleTaskName() {
        return this.getTaskName(null, "classes");
    }

    public String getTaskName(@Nullable String verb) {
        return this.getTaskName(verb, null);
    }

    public String getTaskName(@Nullable String verb, @Nullable String target) {
        String name = this.baseName;
        if (target != null) {
            name = this.collapsedName;
        }
        return GUtil.toLowerCamelCase((CharSequence)String.format("%s %s %s", this.nullToEmpty(verb), name, this.nullToEmpty(target)));
    }

    private String nullToEmpty(String input) {
        return input == null ? "" : input;
    }

    public String getOutputDirectoryBase() {
        return this.baseName;
    }
}

