/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.JvmBinaryTasks;
import org.gradle.jvm.internal.DefaultJvmBinaryTasks;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.platform.base.internal.toolchain.ToolResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassDirectoryBinarySpec
extends AbstractBuildableModelElement
implements ClassDirectoryBinarySpecInternal {
    private final DefaultDomainObjectSet<LanguageSourceSet> sourceSets = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private final BinaryNamingScheme namingScheme;
    private final String name;
    private final JavaToolChain toolChain;
    private final JavaPlatform platform;
    private final DefaultJvmBinaryTasks tasks;
    private final ToolResolver toolResolver;
    private File classesDir;
    private File resourcesDir;
    private boolean buildable = true;

    public DefaultClassDirectoryBinarySpec(String name, JavaToolChain toolChain, JavaPlatform platform, Instantiator instantiator, ITaskFactory taskFactory, ToolResolver toolResolver) {
        this.name = name;
        this.toolChain = toolChain;
        this.platform = platform;
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(this.removeClassesSuffix(name));
        this.tasks = (DefaultJvmBinaryTasks)instantiator.newInstance(DefaultJvmBinaryTasks.class, new Object[]{new DefaultBinaryTasksCollection((BinarySpec)this, taskFactory)});
        this.toolResolver = toolResolver;
    }

    private String removeClassesSuffix(String name) {
        if (name.endsWith("Classes")) {
            return name.substring(0, name.length() - 7);
        }
        return name;
    }

    public JvmBinaryTasks getTasks() {
        return this.tasks;
    }

    public void tasks(Action<? super BinaryTasksCollection> action) {
        action.execute((Object)this.tasks);
    }

    public JavaToolChain getToolChain() {
        return this.toolChain;
    }

    public JavaPlatform getTargetPlatform() {
        return this.platform;
    }

    public void setTargetPlatform(JavaPlatform platform) {
        throw new UnsupportedOperationException();
    }

    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    public ToolResolver getToolResolver() {
        return this.toolResolver;
    }

    public void setToolResolver(ToolResolver toolResolver) {
        throw new UnsupportedOperationException();
    }

    public boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public boolean isLegacyBinary() {
        return true;
    }

    @Override
    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    public String getName() {
        return this.name;
    }

    public File getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public FunctionalSourceSet getBinarySources() {
        throw new UnsupportedOperationException();
    }

    public void setBinarySources(FunctionalSourceSet sources) {
        throw new UnsupportedOperationException();
    }

    public void sources(Action<? super PolymorphicDomainObjectContainer<LanguageSourceSet>> action) {
        throw new UnsupportedOperationException();
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    public void source(Object source) {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        return this.namingScheme.getDescription();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public BinaryBuildAbility getBuildAbility() {
        if (!this.buildable) {
            return new FixedBuildAbility(false);
        }
        return new ToolSearchBuildAbility(this.toolResolver.checkToolAvailability((Platform)this.getTargetPlatform()));
    }
}

