/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.testing.TestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestFilter
implements TestFilter {
    private Set<String> testNames = new HashSet<String>();

    private void validateName(String name) {
        if (name == null || name.length() == 0) {
            throw new InvalidUserDataException("Selected test name cannot be null or empty.");
        }
    }

    @Override
    public TestFilter includeTestsMatching(String testNamePattern) {
        this.validateName(testNamePattern);
        this.testNames.add(testNamePattern);
        return this;
    }

    @Override
    @Input
    public Set<String> getIncludePatterns() {
        return this.testNames;
    }

    @Override
    public TestFilter setIncludePatterns(String ... testNamePatterns) {
        for (String name : testNamePatterns) {
            this.validateName(name);
        }
        this.testNames = Sets.newHashSet((Object[])testNamePatterns);
        return this;
    }
}

