/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.tasks.testing.TestClassLoaderFactory;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitDetector;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassProcessor;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.messaging.actor.ActorFactory;
import org.gradle.process.internal.WorkerProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestFramework
implements TestFramework {
    private JUnitOptions options;
    private final JUnitDetector detector;
    private final DefaultTestFilter filter;
    private final TestClassLoaderFactory classLoaderFactory;

    public JUnitTestFramework(Test testTask, DefaultTestFilter filter, ClassLoaderCache classLoaderCache) {
        this.filter = filter;
        this.options = new JUnitOptions();
        this.detector = new JUnitDetector(new ClassFileExtractionManager((Factory<File>)testTask.getTemporaryDirFactory()));
        this.classLoaderFactory = new TestClassLoaderFactory(classLoaderCache, testTask);
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        this.verifyJUnitCategorySupport();
        this.verifyJUnitFilteringSupport();
        return new TestClassProcessorFactoryImpl(new JUnitSpec(this.options.getIncludeCategories(), this.options.getExcludeCategories(), this.filter.getIncludePatterns()));
    }

    private void verifyJUnitCategorySupport() {
        if (!this.options.getExcludeCategories().isEmpty() || !this.options.getIncludeCategories().isEmpty()) {
            try {
                this.getTestClassLoader().loadClass("org.junit.experimental.categories.Category");
            }
            catch (ClassNotFoundException e) {
                throw new GradleException("JUnit Categories defined but declared JUnit version does not support Categories.");
            }
        }
    }

    private void verifyJUnitFilteringSupport() {
        if (!this.filter.getIncludePatterns().isEmpty()) {
            try {
                Class<?> descriptionClass = this.getTestClassLoader().loadClass("org.junit.runner.Description");
                descriptionClass.getMethod("getClassName", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                this.filteringNotSupported();
            }
            catch (NoSuchMethodException e) {
                this.filteringNotSupported();
            }
            catch (Exception e) {
                throw new RuntimeException("Problem encountered when detecting support for JUnit filtering.", e);
            }
        }
    }

    private ClassLoader getTestClassLoader() {
        return this.classLoaderFactory.create();
    }

    private void filteringNotSupported() {
        throw new GradleException("Test filtering is not supported for given version of JUnit. Please upgrade JUnit version to at least 4.6.");
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return new Action<WorkerProcessBuilder>(){

            public void execute(WorkerProcessBuilder workerProcessBuilder) {
                workerProcessBuilder.sharedPackages(new String[]{"junit.framework"});
                workerProcessBuilder.sharedPackages(new String[]{"junit.extensions"});
                workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
            }
        };
    }

    @Override
    public JUnitOptions getOptions() {
        return this.options;
    }

    void setOptions(JUnitOptions options) {
        this.options = options;
    }

    @Override
    public JUnitDetector getDetector() {
        return this.detector;
    }

    private static class TestClassProcessorFactoryImpl
    implements WorkerTestClassProcessorFactory,
    Serializable {
        private final JUnitSpec spec;

        public TestClassProcessorFactoryImpl(JUnitSpec spec) {
            this.spec = spec;
        }

        public TestClassProcessor create(ServiceRegistry serviceRegistry) {
            return new JUnitTestClassProcessor(this.spec, (IdGenerator)serviceRegistry.get(IdGenerator.class), (ActorFactory)serviceRegistry.get(ActorFactory.class), (TimeProvider)serviceRegistry.get(TimeProvider.class));
        }
    }
}

