/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultWriter;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputAssociation;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;
import org.gradle.util.Clock;

public class Binary2JUnitXmlReportGenerator {
    private final File testResultsDir;
    private final TestResultsProvider testResultsProvider;
    JUnitXmlResultWriter saxWriter;
    private static final Logger LOG = Logging.getLogger(Binary2JUnitXmlReportGenerator.class);

    public Binary2JUnitXmlReportGenerator(File testResultsDir, TestResultsProvider testResultsProvider, TestOutputAssociation outputAssociation) {
        this.testResultsDir = testResultsDir;
        this.testResultsProvider = testResultsProvider;
        this.saxWriter = new JUnitXmlResultWriter(Binary2JUnitXmlReportGenerator.getHostname(), testResultsProvider, outputAssociation);
    }

    public void generate() {
        Clock clock = new Clock();
        this.testResultsProvider.visitClasses((Action<? super TestClassResult>)new Action<TestClassResult>(){

            public void execute(TestClassResult result) {
                File file = new File(Binary2JUnitXmlReportGenerator.this.testResultsDir, Binary2JUnitXmlReportGenerator.this.getReportFileName(result));
                BufferedOutputStream output = null;
                try {
                    output = new BufferedOutputStream(new FileOutputStream(file));
                    Binary2JUnitXmlReportGenerator.this.saxWriter.write(result, output);
                    ((OutputStream)output).close();
                }
                catch (Exception e) {
                    try {
                        throw new GradleException(String.format("Could not write XML test results for %s to file %s.", result.getClassName(), file), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(output);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)output);
            }
        });
        LOG.info("Finished generating test XML results ({}) into: {}", (Object)clock.getTime(), (Object)this.testResultsDir);
    }

    private String getReportFileName(TestClassResult result) {
        return "TEST-" + FileUtils.toSafeFileName((String)result.getClassName()) + ".xml";
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

