/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppIndexingApiDetector
extends Detector
implements Detector.XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue ISSUE_ERROR = Issue.create("AppIndexingError", "Wrong Usage of App Indexing", "Ensures the app can correctly handle deep links and integrate with App Indexing for Google search.", Category.USABILITY, 5, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing");
    public static final Issue ISSUE_WARNING = Issue.create("AppIndexingWarning", "Missing App Indexing Support", "Ensures the app can correctly handle deep links and integrate with App Indexing for Google search.", Category.USABILITY, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing");
    private static final String[] PATH_ATTR_LIST = new String[]{"pathPrefix", "path"};

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("intent-filter");
    }

    @Override
    public void visitElement(XmlContext context, Element intent) {
        boolean actionView = AppIndexingApiDetector.hasActionView(intent);
        boolean browsable = AppIndexingApiDetector.isBrowsable(intent);
        boolean isHttp = false;
        boolean hasScheme = false;
        boolean hasHost = false;
        boolean hasPort = false;
        boolean hasPath = false;
        boolean hasMimeType = false;
        Element firstData = null;
        NodeList children = intent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("data")) continue;
            Element data = (Element)child;
            if (firstData == null) {
                firstData = data;
            }
            if (AppIndexingApiDetector.isHttpSchema(data)) {
                isHttp = true;
            }
            AppIndexingApiDetector.checkSingleData(context, data);
            for (String name : PATH_ATTR_LIST) {
                if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name)) continue;
                hasPath = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme")) {
                hasScheme = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) {
                hasHost = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
                hasPort = true;
            }
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", "mimeType")) continue;
            hasMimeType = true;
        }
        if ((hasPath || hasHost || hasPort) && !hasScheme) {
            context.report(ISSUE_ERROR, firstData, context.getLocation(firstData), "android:scheme missing");
        }
        if ((hasPath || hasPort) && !hasHost) {
            context.report(ISSUE_ERROR, firstData, context.getLocation(firstData), "android:host missing");
        }
        if (actionView && browsable) {
            if (firstData == null) {
                context.report(ISSUE_ERROR, intent, context.getLocation(intent), "Missing data node?");
            } else if (!hasScheme && !hasMimeType) {
                context.report(ISSUE_ERROR, firstData, context.getLocation(firstData), "Missing URL for the intent filter?");
            }
        }
        if (actionView && isHttp && !browsable) {
            context.report(ISSUE_WARNING, intent, context.getLocation(intent), "Activity supporting ACTION_VIEW is not set as BROWSABLE");
        }
    }

    private static boolean hasActionView(Element intent) {
        NodeList children = intent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attr;
            Element action;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("action") || !(action = (Element)child).hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue().equals("android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBrowsable(Element intent) {
        NodeList children = intent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Attr attr;
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("category") || !(e = (Element)child).hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue().equals("android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private static boolean isHttpSchema(Element data) {
        String value;
        return data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme") && ((value = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "scheme").getValue()).equalsIgnoreCase("http") || value.equalsIgnoreCase("https"));
    }

    private static void checkSingleData(XmlContext context, Element data) {
        for (String name : PATH_ATTR_LIST) {
            Attr attr;
            String path;
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name) || (path = AppIndexingApiDetector.replaceUrlWithValue(context, (attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", name)).getValue())).startsWith("/") || path.startsWith("@")) continue;
            context.report(ISSUE_ERROR, attr, context.getLocation(attr), "android:" + name + " attribute should start with '/', but it is : " + path);
        }
        if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
            Attr attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "port");
            try {
                String port = AppIndexingApiDetector.replaceUrlWithValue(context, attr.getValue());
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                context.report(ISSUE_ERROR, attr, context.getLocation(attr), "android:port is not a legal number");
            }
        }
        NamedNodeMap attrs = data.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            Node item = attrs.item(i);
            if (item.getNodeType() != 2 || !(attr = (Attr)attrs.item(i)).getValue().isEmpty()) continue;
            context.report(ISSUE_ERROR, attr, context.getLocation(attr), attr.getName() + " cannot be empty");
        }
    }

    private static String replaceUrlWithValue(XmlContext context, String str) {
        Project project = context.getProject();
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return str;
        }
        ResourceUrl style = ResourceUrl.parse((String)str);
        if (style == null || style.type != ResourceType.STRING || style.framework) {
            return str;
        }
        AbstractResourceRepository resources = client.getProjectResources(project, true);
        if (resources == null) {
            return str;
        }
        List items = resources.getResourceItem(ResourceType.STRING, style.name);
        if (items == null || items.isEmpty()) {
            return str;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
        if (resourceValue == null) {
            return str;
        }
        return resourceValue.getValue() == null ? str : resourceValue.getValue();
    }
}

