/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Node;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;

public class ParcelDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("ParcelCreator", "Missing Parcelable `CREATOR` field", "According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.", Category.USABILITY, 3, Severity.ERROR, new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcelable.html");

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(ClassDeclaration.class);
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext context) {
        return new ParcelVisitor(context);
    }

    private static class ParcelVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public ParcelVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            int flags = node.astModifiers().getExplicitModifierFlags();
            if ((flags & 0x600) != 0) {
                return true;
            }
            if (node.astImplementing() != null) {
                for (TypeReference reference : node.astImplementing()) {
                    JavaParser.ResolvedClass parcelable;
                    JavaParser.ResolvedClass cls;
                    JavaParser.ResolvedField field;
                    String name = ((TypeReferencePart)reference.astParts().last()).astIdentifier().astValue();
                    if (!name.equals("Parcelable")) continue;
                    JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
                    if (!(resolved instanceof JavaParser.ResolvedClass) || (field = (cls = (JavaParser.ResolvedClass)resolved).getField("CREATOR", false)) != null) break;
                    JavaParser.ResolvedNode r = this.mContext.resolve((Node)reference);
                    if (r instanceof JavaParser.ResolvedClass && !(parcelable = (JavaParser.ResolvedClass)r).isSubclassOf("android.os.Parcelable", false)) {
                        return true;
                    }
                    Location location = this.mContext.getLocation((Node)node.astName());
                    this.mContext.report(ISSUE, (Node)node, location, "This class implements `Parcelable` but does not provide a `CREATOR` field");
                    break;
                }
            }
            return true;
        }
    }
}

