/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.analyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AnalysisReport {
    private Set<Listener> mListeners = new HashSet<Listener>();
    private List<AnalysisResultEntry> mAnalysisResults = new ArrayList<AnalysisResultEntry>();
    private boolean mCompleted = false;
    private boolean mCancelled = false;

    public void addAnalysisResultEntries(List<AnalysisResultEntry> entries) {
        this.mAnalysisResults.addAll(entries);
        for (Listener listener : this.mListeners) {
            listener.onResultsAdded(entries);
        }
    }

    public void setCompleted() {
        if (this.mCompleted || this.mCancelled) {
            return;
        }
        this.mCompleted = true;
        for (Listener listener : this.mListeners) {
            listener.onAnalysisComplete();
        }
    }

    public void setCancelled() {
        if (this.mCompleted || this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        for (Listener listener : this.mListeners) {
            listener.onAnalysisCancelled();
        }
    }

    public void addResultListener(Listener listener) {
        if (this.mListeners.contains(listener)) {
            return;
        }
        this.mListeners.add(listener);
        listener.onResultsAdded(this.mAnalysisResults);
        if (this.mCompleted) {
            listener.onAnalysisComplete();
        } else if (this.mCancelled) {
            listener.onAnalysisCancelled();
        }
    }

    public void removeResultListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    public static interface Listener {
        public void onResultsAdded(List<AnalysisResultEntry> var1);

        public void onAnalysisComplete();

        public void onAnalysisCancelled();
    }
}

