/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import java.util.ArrayList;
import java.util.List;

public class LeakedActivityAnalyzerTask
extends MemoryAnalyzerTask {
    @Override
    List<AnalysisResultEntry> analyze(Snapshot snapshot) {
        ArrayList<Instance> leakingInstances = new ArrayList<Instance>();
        List<ClassObj> activityClasses = snapshot.findAllDescendantClasses("android.app.Activity");
        for (ClassObj activityClass : activityClasses) {
            block1: for (Instance instance : activityClass.getInstancesList()) {
                Instance immediateDominator = instance.getImmediateDominator();
                if (!(instance instanceof ClassInstance) || immediateDominator == null) continue;
                for (ClassInstance.FieldValue value : ((ClassInstance)instance).getValues()) {
                    if (!"mFinished".equals(value.getField().getName()) && !"mDestroyed".equals(value.getField().getName()) || instance.getDistanceToGcRoot() == Integer.MAX_VALUE || !(value.getValue() instanceof Boolean) || !((Boolean)value.getValue()).booleanValue()) continue;
                    leakingInstances.add(instance);
                    continue block1;
                }
            }
        }
        ArrayList<AnalysisResultEntry> results = new ArrayList<AnalysisResultEntry>(leakingInstances.size());
        for (Instance instance : leakingInstances) {
            results.add(new MemoryAnalysisEntry(instance.getClassObj().getClassName(), instance.getStack()));
        }
        return results;
    }

    @Override
    public String getTaskName() {
        return "Leaked Activity";
    }

    @Override
    public String getTaskDescription() {
        return "Detects leaked activities in Android applications.";
    }

    private static class MemoryAnalysisEntry
    implements AnalysisResultEntry {
        private String mOffender;
        private StackTrace mStackTrace;

        private MemoryAnalysisEntry(String offender, StackTrace stackTrace) {
            this.mOffender = offender;
            this.mStackTrace = stackTrace;
        }

        @Override
        public String getWarningMessage() {
            return "Leaked activity detected";
        }

        @Override
        public String getCategory() {
            return "LeakedActivity";
        }

        @Override
        public String getOffender() {
            return this.mOffender;
        }

        @Override
        public StackTrace getStackTrace() {
            return this.mStackTrace;
        }
    }
}

