/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace.viz;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class ZoomPanInteractor
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final double WHEEL_UNIT_SCALE = -0.1;
    private final AffineTransform mTransform = new AffineTransform();
    private AffineTransform mInverseTransform;
    private final Point2D mTmpPoint = new Point2D.Double();
    private int mLastX;
    private int mLastY;
    private final List<ViewTransformListener> mListeners = new ArrayList<ViewTransformListener>();

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mLastX = e.getX();
        this.mLastY = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int deltaX = e.getX() - this.mLastX;
        int deltaY = e.getY() - this.mLastY;
        this.translateBy(deltaX, deltaY);
        this.notifyTransformChange();
        this.mLastX = e.getX();
        this.mLastY = e.getY();
    }

    void translateBy(int deltaX, int deltaY) {
        deltaX = (int)((double)deltaX / this.mTransform.getScaleX());
        deltaY = (int)((double)deltaY / this.mTransform.getScaleY());
        this.mTransform.translate(deltaX, deltaY);
        if (this.mTransform.getTranslateY() > 0.0) {
            this.mTransform.translate(0.0, -this.mTransform.getTranslateY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() != 0) {
            return;
        }
        double scale = 1.0 + -0.1 * (double)e.getWheelRotation();
        this.mTmpPoint.setLocation(e.getX(), e.getY());
        this.mInverseTransform.transform(this.mTmpPoint, this.mTmpPoint);
        this.zoomBy(scale, 1.0, this.mTmpPoint);
        this.notifyTransformChange();
    }

    void zoomBy(double scaleX, double scaleY, Point2D location) {
        this.mTransform.translate(location.getX(), location.getY());
        this.mTransform.scale(scaleX, scaleY);
        this.mTransform.translate(-location.getX(), -location.getY());
    }

    private void notifyTransformChange() {
        try {
            this.mInverseTransform = this.mTransform.createInverse();
        }
        catch (NoninvertibleTransformException ignored) {
            // empty catch block
        }
        for (ViewTransformListener l : this.mListeners) {
            l.transformChanged(this.mTransform);
        }
    }

    public void setToScaleX(double sx, double sy) {
        this.mTransform.setToScale(sx, sy);
        this.notifyTransformChange();
    }

    AffineTransform getTransform() {
        return this.mTransform;
    }

    public void addViewTransformListener(ViewTransformListener l) {
        this.mListeners.add(l);
    }

    public static interface ViewTransformListener {
        public void transformChanged(AffineTransform var1);
    }
}

