/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cunit.plugins;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultFunctionalSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.c.CSourceSet;
import org.gradle.language.c.internal.DefaultCSourceSet;
import org.gradle.language.c.plugins.CLangPlugin;
import org.gradle.language.nativeplatform.internal.DefaultPreprocessingTool;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.test.cunit.CUnitTestSuiteSpec;
import org.gradle.nativeplatform.test.cunit.internal.DefaultCUnitTestSuiteBinary;
import org.gradle.nativeplatform.test.cunit.internal.DefaultCUnitTestSuiteSpec;
import org.gradle.nativeplatform.test.cunit.tasks.GenerateCUnitLauncher;
import org.gradle.nativeplatform.test.plugins.NativeBinariesTestPlugin;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.test.TestSuiteContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class CUnitPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NativeBinariesTestPlugin.class);
        project.getPluginManager().apply(CLangPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        private static final String CUNIT_LAUNCHER_SOURCE_SET = "cunitLauncher";

        Rules() {
        }

        @Defaults
        public void createCUnitTestSuitePerComponent(TestSuiteContainer testSuites, NamedDomainObjectSet<NativeComponentSpec> components, ProjectSourceSet projectSourceSet, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            for (NativeComponentSpec component : components) {
                testSuites.add((Object)this.createCUnitTestSuite(component, instantiator, projectSourceSet, fileResolver));
            }
        }

        private CUnitTestSuiteSpec createCUnitTestSuite(NativeComponentSpec testedComponent, Instantiator instantiator, ProjectSourceSet projectSourceSet, FileResolver fileResolver) {
            String suiteName = String.format("%sTest", testedComponent.getName());
            String path = testedComponent.getProjectPath();
            DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(path, suiteName);
            FunctionalSourceSet testSuiteSourceSet = this.createCUnitSources(instantiator, suiteName, projectSourceSet, fileResolver);
            CUnitTestSuiteSpec testSuiteSpec = (CUnitTestSuiteSpec)BaseComponentSpec.create(DefaultCUnitTestSuiteSpec.class, (ComponentSpecIdentifier)id, (FunctionalSourceSet)testSuiteSourceSet, (Instantiator)instantiator);
            testSuiteSpec.setTestedComponent(testedComponent);
            return testSuiteSpec;
        }

        private FunctionalSourceSet createCUnitSources(final Instantiator instantiator, final String suiteName, ProjectSourceSet projectSourceSet, final FileResolver fileResolver) {
            FunctionalSourceSet functionalSourceSet = (FunctionalSourceSet)instantiator.newInstance(DefaultFunctionalSourceSet.class, new Object[]{suiteName, instantiator, projectSourceSet});
            functionalSourceSet.registerFactory(CSourceSet.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<CSourceSet>(){

                public CSourceSet create(String name) {
                    return (CSourceSet)BaseLanguageSourceSet.create(DefaultCSourceSet.class, (String)name, (String)suiteName, (FileResolver)fileResolver, (Instantiator)instantiator);
                }
            });
            return functionalSourceSet;
        }

        @Finalize
        public void configureCUnitTestSuiteSources(TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class)) {
                FunctionalSourceSet suiteSourceSet = ((ComponentSpecInternal)suite).getSources();
                CSourceSet launcherSources = (CSourceSet)suiteSourceSet.maybeCreate(CUNIT_LAUNCHER_SOURCE_SET, CSourceSet.class);
                File baseDir = new File(buildDir, String.format("src/%s/cunitLauncher", suite.getName()));
                launcherSources.getSource().srcDir((Object)new File(baseDir, "c"));
                launcherSources.getExportedHeaders().srcDir((Object)new File(baseDir, "headers"));
                CSourceSet testSources = (CSourceSet)suiteSourceSet.maybeCreate("c", CSourceSet.class);
                testSources.getSource().srcDir((Object)String.format("src/%s/%s", suite.getName(), "c"));
                testSources.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", suite.getName()));
                testSources.lib((Object)launcherSources);
            }
        }

        @Mutate
        public void createCUnitLauncherTasks(TaskContainer tasks, TestSuiteContainer testSuites) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class)) {
                String taskName = suite.getName() + "CUnitLauncher";
                GenerateCUnitLauncher skeletonTask = (GenerateCUnitLauncher)tasks.create(taskName, GenerateCUnitLauncher.class);
                CSourceSet launcherSources = this.findLaucherSources(suite);
                skeletonTask.setSourceDir((File)launcherSources.getSource().getSrcDirs().iterator().next());
                skeletonTask.setHeaderDir((File)launcherSources.getExportedHeaders().getSrcDirs().iterator().next());
                launcherSources.builtBy(new Object[]{skeletonTask});
            }
        }

        private CSourceSet findLaucherSources(CUnitTestSuiteSpec suite) {
            return (CSourceSet)suite.getSource().withType(CSourceSet.class).matching((Spec)new Spec<CSourceSet>(){

                public boolean isSatisfiedBy(CSourceSet element) {
                    return element.getName().equals(Rules.CUNIT_LAUNCHER_SOURCE_SET);
                }
            }).iterator().next();
        }

        @Mutate
        public void createCUnitTestBinaries(BinaryContainer binaries, TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry, ITaskFactory taskFactory) {
            for (CUnitTestSuiteSpec cUnitTestSuite : testSuites.withType(CUnitTestSuiteSpec.class)) {
                for (NativeBinarySpec testedBinary : cUnitTestSuite.getTestedComponent().getBinaries().withType(NativeBinarySpec.class)) {
                    if (testedBinary instanceof SharedLibraryBinary) continue;
                    DefaultCUnitTestSuiteBinary testBinary = this.createTestBinary(serviceRegistry, cUnitTestSuite, testedBinary, taskFactory);
                    this.configure(testBinary, buildDir);
                    cUnitTestSuite.getBinaries().add((Object)testBinary);
                    binaries.add((Object)testBinary);
                }
            }
        }

        private DefaultCUnitTestSuiteBinary createTestBinary(ServiceRegistry serviceRegistry, CUnitTestSuiteSpec cUnitTestSuite, NativeBinarySpec testedBinary, ITaskFactory taskFactory) {
            BinaryNamingScheme namingScheme = new DefaultBinaryNamingSchemeBuilder(((NativeBinarySpecInternal)testedBinary).getNamingScheme()).withComponentName(cUnitTestSuite.getBaseName()).withTypeString("CUnitExe").build();
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            return DefaultCUnitTestSuiteBinary.create((NativeComponentSpec)cUnitTestSuite, (NativeBinarySpecInternal)testedBinary, namingScheme, resolver, instantiator, taskFactory);
        }

        private void configure(DefaultCUnitTestSuiteBinary testBinary, File buildDir) {
            BinaryNamingScheme namingScheme = testBinary.getNamingScheme();
            PlatformToolProvider toolProvider = testBinary.getPlatformToolProvider();
            File binaryOutputDir = new File(new File(buildDir, "binaries"), namingScheme.getOutputDirectoryBase());
            String baseName = testBinary.getComponent().getBaseName();
            testBinary.setExecutableFile(new File(binaryOutputDir, toolProvider.getExecutableName(baseName)));
            ((ExtensionAware)testBinary).getExtensions().create("cCompiler", DefaultPreprocessingTool.class, new Object[0]);
        }
    }
}

