/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.googletest.plugins;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultFunctionalSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.cpp.CppSourceSet;
import org.gradle.language.cpp.internal.DefaultCppSourceSet;
import org.gradle.language.cpp.plugins.CppLangPlugin;
import org.gradle.language.nativeplatform.internal.DefaultPreprocessingTool;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.test.googletest.GoogleTestTestSuiteSpec;
import org.gradle.nativeplatform.test.googletest.internal.DefaultGoogleTestTestSuiteBinary;
import org.gradle.nativeplatform.test.googletest.internal.DefaultGoogleTestTestSuiteSpec;
import org.gradle.nativeplatform.test.plugins.NativeBinariesTestPlugin;
import org.gradle.nativeplatform.toolchain.GccCompatibleToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.test.TestSuiteContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class GoogleTestPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.apply(Collections.singletonMap("plugin", NativeBinariesTestPlugin.class));
        project.apply(Collections.singletonMap("plugin", CppLangPlugin.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Defaults
        public void createGoogleTestTestSuitePerComponent(TestSuiteContainer testSuites, NamedDomainObjectSet<NativeComponentSpec> components, ProjectSourceSet projectSourceSet, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            for (NativeComponentSpec component : components) {
                testSuites.add((Object)this.createGoogleTestTestSuite(component, instantiator, projectSourceSet, fileResolver));
            }
        }

        private GoogleTestTestSuiteSpec createGoogleTestTestSuite(NativeComponentSpec testedComponent, Instantiator instantiator, ProjectSourceSet projectSourceSet, FileResolver fileResolver) {
            String suiteName = String.format("%sTest", testedComponent.getName());
            String path = testedComponent.getProjectPath();
            DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(path, suiteName);
            FunctionalSourceSet testSuiteSourceSet = this.createGoogleTestSources(instantiator, suiteName, projectSourceSet, fileResolver);
            GoogleTestTestSuiteSpec testSuiteSpec = (GoogleTestTestSuiteSpec)BaseComponentSpec.create(DefaultGoogleTestTestSuiteSpec.class, (ComponentSpecIdentifier)id, (FunctionalSourceSet)testSuiteSourceSet, (Instantiator)instantiator);
            testSuiteSpec.setTestedComponent(testedComponent);
            return testSuiteSpec;
        }

        private FunctionalSourceSet createGoogleTestSources(final Instantiator instantiator, final String suiteName, ProjectSourceSet projectSourceSet, final FileResolver fileResolver) {
            FunctionalSourceSet functionalSourceSet = (FunctionalSourceSet)instantiator.newInstance(DefaultFunctionalSourceSet.class, new Object[]{suiteName, instantiator, projectSourceSet});
            functionalSourceSet.registerFactory(CppSourceSet.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<CppSourceSet>(){

                public CppSourceSet create(String name) {
                    return (CppSourceSet)BaseLanguageSourceSet.create(DefaultCppSourceSet.class, (String)name, (String)suiteName, (FileResolver)fileResolver, (Instantiator)instantiator);
                }
            });
            return functionalSourceSet;
        }

        @Finalize
        public void configureGoogleTestTestSuiteSources(TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir) {
            for (GoogleTestTestSuiteSpec suite : testSuites.withType(GoogleTestTestSuiteSpec.class)) {
                FunctionalSourceSet suiteSourceSet = ((ComponentSpecInternal)suite).getSources();
                CppSourceSet testSources = (CppSourceSet)suiteSourceSet.maybeCreate("cpp", CppSourceSet.class);
                testSources.getSource().srcDir((Object)String.format("src/%s/%s", suite.getName(), "cpp"));
                testSources.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", suite.getName()));
            }
        }

        @Mutate
        public void createGoogleTestTestBinaries(BinaryContainer binaries, TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry, ITaskFactory taskFactory) {
            for (GoogleTestTestSuiteSpec googleTestTestSuite : testSuites.withType(GoogleTestTestSuiteSpec.class)) {
                for (NativeBinarySpec testedBinary : googleTestTestSuite.getTestedComponent().getBinaries().withType(NativeBinarySpec.class)) {
                    if (testedBinary instanceof SharedLibraryBinary) continue;
                    DefaultGoogleTestTestSuiteBinary testBinary = this.createTestBinary(serviceRegistry, googleTestTestSuite, testedBinary, taskFactory);
                    this.configure(testBinary, buildDir);
                    googleTestTestSuite.getBinaries().add((Object)testBinary);
                    binaries.add((Object)testBinary);
                }
            }
        }

        private DefaultGoogleTestTestSuiteBinary createTestBinary(ServiceRegistry serviceRegistry, GoogleTestTestSuiteSpec googleTestTestSuite, NativeBinarySpec testedBinary, ITaskFactory taskFactory) {
            BinaryNamingScheme namingScheme = new DefaultBinaryNamingSchemeBuilder(((NativeBinarySpecInternal)testedBinary).getNamingScheme()).withComponentName(googleTestTestSuite.getBaseName()).withTypeString("GoogleTestExe").build();
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            return DefaultGoogleTestTestSuiteBinary.create((NativeComponentSpec)googleTestTestSuite, (NativeBinarySpecInternal)testedBinary, namingScheme, resolver, instantiator, taskFactory);
        }

        private void configure(DefaultGoogleTestTestSuiteBinary testBinary, File buildDir) {
            BinaryNamingScheme namingScheme = testBinary.getNamingScheme();
            PlatformToolProvider toolProvider = testBinary.getPlatformToolProvider();
            File binaryOutputDir = new File(new File(buildDir, "binaries"), namingScheme.getOutputDirectoryBase());
            String baseName = testBinary.getComponent().getBaseName();
            testBinary.setExecutableFile(new File(binaryOutputDir, toolProvider.getExecutableName(baseName)));
            ((ExtensionAware)testBinary).getExtensions().create("cppCompiler", DefaultPreprocessingTool.class, new Object[0]);
            if (testBinary.getToolChain() instanceof GccCompatibleToolChain && testBinary.getTargetPlatform().getOperatingSystem().isLinux()) {
                testBinary.getLinker().args(new String[]{"-pthread"});
            }
        }
    }
}

