/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.play.internal.platform.PlayPlatformInternal;

public class DefaultPlayPlatform
implements PlayPlatformInternal {
    private final String playVersion;
    private final ScalaPlatform scalaPlatform;
    private final JavaPlatform javaPlatform;
    private final String name;

    public DefaultPlayPlatform(String name, String playVersion, ScalaPlatform scalaPlatform, JavaPlatform javaPlatform) {
        this.name = name;
        this.playVersion = playVersion;
        this.scalaPlatform = scalaPlatform;
        this.javaPlatform = javaPlatform;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return String.format("Play Platform (Play %s, Scala: %s, Java: %s)", this.playVersion, this.scalaPlatform.getScalaCompatibilityVersion(), this.javaPlatform.getDisplayName());
    }

    public String getPlayVersion() {
        return this.playVersion;
    }

    public ScalaPlatform getScalaPlatform() {
        return this.scalaPlatform;
    }

    public JavaPlatform getJavaPlatform() {
        return this.javaPlatform;
    }

    public String getDependencyNotation(String playModule) {
        return String.format("com.typesafe.play:%s_%s:%s", playModule, this.scalaPlatform.getScalaCompatibilityVersion(), this.playVersion);
    }
}

