/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.jar.JarFile;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultVersionedPlayRunAdapter
implements VersionedPlayRunAdapter,
Serializable {
    protected abstract Class<?> getBuildLinkClass(ClassLoader var1) throws ClassNotFoundException;

    protected abstract Class<?> getDocHandlerFactoryClass(ClassLoader var1) throws ClassNotFoundException;

    protected abstract Class<?> getBuildDocHandlerClass(ClassLoader var1) throws ClassNotFoundException;

    @Override
    public Object getBuildLink(ClassLoader classLoader, final File projectPath, final Iterable<File> classpath) throws ClassNotFoundException {
        return Proxy.newProxyInstance(classLoader, new Class[]{this.getBuildLinkClass(classLoader)}, new InvocationHandler(){
            private volatile boolean shouldReloadNextTime = true;

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("projectPath")) {
                    return projectPath;
                }
                if (method.getName().equals("reload")) {
                    if (this.shouldReloadNextTime) {
                        this.shouldReloadNextTime = false;
                        DefaultClassPath projectClasspath = new DefaultClassPath(classpath);
                        return new URLClassLoader(projectClasspath.getAsURLs().toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
                    }
                    return null;
                }
                if (method.getName().equals("settings")) {
                    return new HashMap();
                }
                return null;
            }
        });
    }

    @Override
    public Object getBuildDocHandler(ClassLoader docsClassLoader, Iterable<File> classpath) throws NoSuchMethodException, ClassNotFoundException, IOException, IllegalAccessException {
        Class<?> docHandlerFactoryClass = this.getDocHandlerFactoryClass(docsClassLoader);
        Method docHandlerFactoryMethod = docHandlerFactoryClass.getMethod("fromJar", JarFile.class, String.class);
        JarFile documentationJar = this.findDocumentationJar(classpath);
        try {
            return docHandlerFactoryMethod.invoke(null, documentationJar, "play/docs/content");
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
        }
    }

    private JarFile findDocumentationJar(Iterable<File> classpath) throws IOException {
        File docJarFile = null;
        for (File file : classpath) {
            if (!file.getName().startsWith("play-docs")) continue;
            docJarFile = file;
            break;
        }
        return new JarFile(docJarFile);
    }

    @Override
    public ScalaMethod getNettyServerDevHttpMethod(ClassLoader classLoader, ClassLoader docsClassLoader) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(classLoader, "play.core.server.NettyServer", "mainDevHttpMode", this.getBuildLinkClass(classLoader), this.getBuildDocHandlerClass(docsClassLoader), Integer.TYPE);
    }
}

