/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.play.internal.run.PlayAppLifecycleUpdate;
import org.gradle.play.internal.run.PlayRunSpec;
import org.gradle.play.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.play.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.scala.internal.reflect.ScalaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayWorkerServer
implements Action<WorkerProcessContext>,
PlayRunWorkerServerProtocol,
Serializable {
    private PlayRunSpec runSpec;
    private VersionedPlayRunAdapter spec;
    private volatile CountDownLatch stop;

    public PlayWorkerServer(PlayRunSpec runSpec, VersionedPlayRunAdapter spec) {
        this.runSpec = runSpec;
        this.spec = spec;
    }

    public void execute(WorkerProcessContext context) {
        this.stop = new CountDownLatch(1);
        PlayRunWorkerClientProtocol clientProtocol = (PlayRunWorkerClientProtocol)context.getServerConnection().addOutgoing(PlayRunWorkerClientProtocol.class);
        context.getServerConnection().addIncoming(PlayRunWorkerServerProtocol.class, (Object)this);
        context.getServerConnection().connect();
        PlayAppLifecycleUpdate result = this.startServer();
        try {
            clientProtocol.update(result);
            this.stop.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            clientProtocol.update(PlayAppLifecycleUpdate.stopped());
        }
    }

    private PlayAppLifecycleUpdate startServer() {
        try {
            this.run();
            return PlayAppLifecycleUpdate.running();
        }
        catch (Exception e) {
            Logging.getLogger(this.getClass()).error("Failed to run Play", (Throwable)e);
            return PlayAppLifecycleUpdate.failed(e);
        }
    }

    private void run() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ClassLoader docsClassLoader = this.getClass().getClassLoader();
            Object buildDocHandler = this.spec.getBuildDocHandler(docsClassLoader, this.runSpec.getClasspath());
            ScalaMethod runMethod = this.spec.getNettyServerDevHttpMethod(classLoader, docsClassLoader);
            Object buildLink = this.spec.getBuildLink(classLoader, this.runSpec.getProjectPath(), this.runSpec.getClasspath());
            runMethod.invoke(buildLink, buildDocHandler, this.runSpec.getHttpPort());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void stop() {
        this.stop.countDown();
    }
}

