/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.twirl.TwirlCompiler;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterV10X;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterV22X;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.play.platform.PlayPlatform;

public class TwirlCompilerFactory {
    public static TwirlCompiler create(PlayPlatform playPlatform) {
        return new TwirlCompiler(TwirlCompilerFactory.createAdapter(playPlatform));
    }

    public static VersionedTwirlCompilerAdapter createAdapter(PlayPlatform playPlatform) {
        String playVersion = playPlatform.getPlayVersion();
        String scalaCompatibilityVersion = playPlatform.getScalaPlatform().getScalaCompatibilityVersion();
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_2_X: {
                return new TwirlCompilerAdapterV22X("2.2.3", scalaCompatibilityVersion);
            }
            case PLAY_2_3_X: {
                return new TwirlCompilerAdapterV10X("1.0.2", scalaCompatibilityVersion);
            }
        }
        throw new RuntimeException("Could not create Twirl compile spec for Play version: " + playVersion);
    }
}

