/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.java.DefaultJvmResourceSet;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.internal.DefaultJavaLanguageSourceSet;
import org.gradle.language.java.plugins.JavaLanguagePlugin;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.routes.RoutesSourceSet;
import org.gradle.language.routes.internal.DefaultRoutesSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.scala.internal.DefaultScalaLanguageSourceSet;
import org.gradle.language.scala.plugins.ScalaLanguagePlugin;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.language.twirl.TwirlSourceSet;
import org.gradle.language.twirl.internal.DefaultTwirlSourceSet;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.platform.base.internal.toolchain.ResolvedTool;
import org.gradle.platform.base.internal.toolchain.ToolResolver;
import org.gradle.play.JvmClasses;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.PublicAssets;
import org.gradle.play.internal.DefaultPlayApplicationBinarySpec;
import org.gradle.play.internal.DefaultPlayApplicationSpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.PlayApplicationSpecInternal;
import org.gradle.play.internal.PlayPlatformResolver;
import org.gradle.play.internal.platform.PlayPlatformInternal;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.TwirlCompilerFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.play.tasks.PlayRun;
import org.gradle.play.tasks.RoutesCompile;
import org.gradle.play.tasks.TwirlCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayApplicationPlugin
implements Plugin<Project> {
    private static final String DEFAULT_PLAY_VERSION = "2.3.7";
    public static final int DEFAULT_HTTP_PORT = 9000;

    public void apply(Project project) {
        project.getPluginManager().apply(JavaLanguagePlugin.class);
        project.getPluginManager().apply(ScalaLanguagePlugin.class);
        project.getExtensions().create("playConfigurations", PlayPluginConfigurations.class, new Object[]{project.getConfigurations(), project.getDependencies()});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        PlayPluginConfigurations configurations(ExtensionContainer extensions) {
            return (PlayPluginConfigurations)extensions.getByType(PlayPluginConfigurations.class);
        }

        @Model
        FileResolver fileResolver(ServiceRegistry serviceRegistry) {
            return (FileResolver)serviceRegistry.get(FileResolver.class);
        }

        @ComponentType
        void register(ComponentTypeBuilder<PlayApplicationSpec> builder) {
            builder.defaultImplementation(DefaultPlayApplicationSpec.class);
        }

        @Mutate
        public void registerPlatformResolver(PlatformResolvers platformResolvers) {
            platformResolvers.register((PlatformResolver)new PlayPlatformResolver());
        }

        @Mutate
        void createDefaultPlayApp(CollectionBuilder<PlayApplicationSpec> builder) {
            builder.create("play");
        }

        @BinaryType
        void registerApplication(BinaryTypeBuilder<PlayApplicationBinarySpec> builder) {
            builder.defaultImplementation(DefaultPlayApplicationBinarySpec.class);
        }

        @LanguageType
        void registerTwirlLanguageType(LanguageTypeBuilder<TwirlSourceSet> builder) {
            builder.setLanguageName("twirl");
            builder.defaultImplementation(DefaultTwirlSourceSet.class);
        }

        @LanguageType
        void registerRoutesLanguageType(LanguageTypeBuilder<RoutesSourceSet> builder) {
            builder.setLanguageName("routes");
            builder.defaultImplementation(DefaultRoutesSourceSet.class);
        }

        @Mutate
        void configureDefaultPlaySources(ComponentSpecContainer components, ServiceRegistry serviceRegistry) {
            final FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            components.withType(PlayApplicationSpec.class).all((Action)new Action<PlayApplicationSpec>(){

                public void execute(PlayApplicationSpec playComponent) {
                    ScalaLanguageSourceSet scalaSources = (ScalaLanguageSourceSet)BaseLanguageSourceSet.create(DefaultScalaLanguageSourceSet.class, (String)"scala", (String)playComponent.getName(), (FileResolver)fileResolver, (Instantiator)instantiator);
                    scalaSources.getSource().srcDir((Object)"app");
                    scalaSources.getSource().include(new String[]{"**/*.scala"});
                    FunctionalSourceSet sources = ((ComponentSpecInternal)playComponent).getSources();
                    sources.add((Object)scalaSources);
                    JavaSourceSet javaSources = (JavaSourceSet)BaseLanguageSourceSet.create(DefaultJavaLanguageSourceSet.class, (String)"java", (String)playComponent.getName(), (FileResolver)fileResolver, (Instantiator)instantiator);
                    javaSources.getSource().srcDir((Object)"app");
                    javaSources.getSource().include(new String[]{"**/*.java"});
                    sources.add((Object)javaSources);
                    DefaultSourceDirectorySet resourcesDirectorySet = new DefaultSourceDirectorySet("resources", fileResolver);
                    JvmResourceSet appResources = (JvmResourceSet)instantiator.newInstance(DefaultJvmResourceSet.class, new Object[]{"resources", playComponent.getName(), resourcesDirectorySet});
                    appResources.getSource().srcDirs(new Object[]{"conf"});
                    sources.add((Object)appResources);
                }
            });
        }

        @Validate
        void failOnMultiplePlayComponents(CollectionBuilder<PlayApplicationSpec> container) {
            if (container.size() >= 2) {
                throw new GradleException("Multiple components of type 'PlayApplicationSpec' are not supported.");
            }
        }

        @Finalize
        void failOnMultipleTargetPlatforms(ComponentSpecContainer container) {
            for (PlayApplicationSpecInternal playApplicationSpec : container.withType(PlayApplicationSpecInternal.class)) {
                if (playApplicationSpec.getTargetPlatforms().size() <= 1) continue;
                throw new GradleException("Multiple target platforms for 'PlayApplicationSpec' is not (yet) supported.");
            }
        }

        @ComponentBinaries
        void createBinaries(CollectionBuilder<PlayApplicationBinarySpec> binaries, final PlayApplicationSpec componentSpec, final PlatformResolvers platforms, final PlayPluginConfigurations configurations, ServiceRegistry serviceRegistry, final @Path(value="buildDir") File buildDir, final ProjectIdentifier projectIdentifier) {
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            final ToolResolver toolResolver = (ToolResolver)serviceRegistry.get(ToolResolver.class);
            final String binaryName = String.format("%sBinary", componentSpec.getName());
            binaries.create(binaryName, (Action)new Action<PlayApplicationBinarySpec>(){

                public void execute(PlayApplicationBinarySpec playBinary) {
                    PlayApplicationBinarySpecInternal playBinaryInternal = (PlayApplicationBinarySpecInternal)playBinary;
                    playBinaryInternal.setApplication(componentSpec);
                    File binaryBuildDir = new File(buildDir, binaryName);
                    PlayPlatform chosenPlatform = Rules.this.resolveTargetPlatform(componentSpec, platforms, configurations);
                    Rules.this.initialiseConfigurations(configurations, chosenPlatform);
                    playBinaryInternal.setTargetPlatform(chosenPlatform);
                    playBinaryInternal.setToolResolver(toolResolver);
                    File mainJar = new File(binaryBuildDir, String.format("lib/%s.jar", projectIdentifier.getName()));
                    File assetsJar = new File(binaryBuildDir, String.format("lib/%s-assets.jar", projectIdentifier.getName()));
                    playBinaryInternal.setJarFile(mainJar);
                    playBinaryInternal.setAssetsJarFile(assetsJar);
                    configurations.getPlay().addArtifact((PublishArtifact)new DefaultPublishArtifact(projectIdentifier.getName(), "jar", "jar", null, new Date(), mainJar, new Object[]{playBinaryInternal}));
                    configurations.getPlay().addArtifact((PublishArtifact)new DefaultPublishArtifact(projectIdentifier.getName(), "jar", "jar", "assets", new Date(), assetsJar, new Object[]{playBinaryInternal}));
                    JvmClasses classes = playBinary.getClasses();
                    classes.setClassesDir(new File(binaryBuildDir, "classes"));
                    DomainObjectSet jvmResourceSets = componentSpec.getSource().withType(JvmResourceSet.class);
                    for (JvmResourceSet jvmResourceSet : jvmResourceSets) {
                        for (File resourceDir : jvmResourceSet.getSource()) {
                            classes.addResourceDir(resourceDir);
                        }
                    }
                    PublicAssets assets = playBinary.getAssets();
                    assets.addAssetDir(new File(projectIdentifier.getProjectDir(), "public"));
                    playBinaryInternal.setClasspath(configurations.getPlay().getFileCollection());
                }
            });
        }

        private PlayPlatform resolveTargetPlatform(PlayApplicationSpec componentSpec, PlatformResolvers platforms, PlayPluginConfigurations configurations) {
            PlatformRequirement targetPlatform = this.getTargetPlatform((PlayApplicationSpecInternal)componentSpec);
            return (PlayPlatform)platforms.resolve(PlayPlatform.class, targetPlatform);
        }

        private PlatformRequirement getTargetPlatform(PlayApplicationSpecInternal playApplicationSpec) {
            if (playApplicationSpec.getTargetPlatforms().isEmpty()) {
                String defaultPlayPlatform = String.format("play-%s", PlayApplicationPlugin.DEFAULT_PLAY_VERSION);
                return DefaultPlatformRequirement.create((String)defaultPlayPlatform);
            }
            if (playApplicationSpec.getTargetPlatforms().size() == 1) {
                return (PlatformRequirement)playApplicationSpec.getTargetPlatforms().get(0);
            }
            throw new InvalidUserDataException("Play application can only target a single platform");
        }

        private void initialiseConfigurations(PlayPluginConfigurations configurations, PlayPlatform playPlatform) {
            configurations.getPlayPlatform().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play"));
            configurations.getPlayTest().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play-test"));
            configurations.getPlayRun().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play-docs"));
        }

        @Mutate
        void createTwirlSourceSets(CollectionBuilder<PlayApplicationSpec> components) {
            components.beforeEach((Action)new Action<PlayApplicationSpec>(){

                public void execute(PlayApplicationSpec playComponent) {
                    TwirlSourceSet twirlSourceSet = (TwirlSourceSet)((ComponentSpecInternal)playComponent).getSources().create("twirlTemplates", TwirlSourceSet.class);
                    twirlSourceSet.getSource().srcDir((Object)"app");
                    twirlSourceSet.getSource().include(new String[]{"**/*.html"});
                }
            });
        }

        @Mutate
        void createRoutesSourceSets(CollectionBuilder<PlayApplicationSpec> components) {
            components.beforeEach((Action)new Action<PlayApplicationSpec>(){

                public void execute(PlayApplicationSpec playComponent) {
                    RoutesSourceSet routesSourceSet = (RoutesSourceSet)((ComponentSpecInternal)playComponent).getSources().create("routesSources", RoutesSourceSet.class);
                    routesSourceSet.getSource().srcDir((Object)"conf");
                    routesSourceSet.getSource().include(new String[]{"routes"});
                    routesSourceSet.getSource().include(new String[]{"*.routes"});
                }
            });
        }

        @Mutate
        void createGeneratedScalaSourceSets(CollectionBuilder<PlayApplicationBinarySpec> binaries, ServiceRegistry serviceRegistry) {
            this.createGeneratedScalaSourceSetsForType(TwirlSourceSet.class, binaries, serviceRegistry);
            this.createGeneratedScalaSourceSetsForType(RoutesSourceSet.class, binaries, serviceRegistry);
        }

        void createGeneratedScalaSourceSetsForType(final Class<? extends LanguageSourceSet> languageSourceSetType, CollectionBuilder<PlayApplicationBinarySpec> binaries, ServiceRegistry serviceRegistry) {
            final FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            binaries.all((Action)new Action<PlayApplicationBinarySpec>(){

                public void execute(PlayApplicationBinarySpec playApplicationBinarySpec) {
                    for (LanguageSourceSet languageSourceSet : playApplicationBinarySpec.getSource().withType(languageSourceSetType)) {
                        ScalaLanguageSourceSet twirlScalaSources = (ScalaLanguageSourceSet)BaseLanguageSourceSet.create(DefaultScalaLanguageSourceSet.class, (String)String.format("%sScalaSources", languageSourceSet.getName()), (String)playApplicationBinarySpec.getName(), (FileResolver)fileResolver, (Instantiator)instantiator);
                        playApplicationBinarySpec.getGeneratedScala().put(languageSourceSet, twirlScalaSources);
                    }
                }
            });
        }

        @BinaryTasks
        void createTwirlCompileTasks(CollectionBuilder<Task> tasks, final PlayApplicationBinarySpec binary, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
            ToolResolver toolResolver = (ToolResolver)serviceRegistry.get(ToolResolver.class);
            final ResolvedTool compilerTool = toolResolver.resolveCompiler(TwirlCompileSpec.class, (Platform)binary.getTargetPlatform());
            for (final TwirlSourceSet twirlSourceSet : binary.getSource().withType(TwirlSourceSet.class)) {
                String twirlCompileTaskName = String.format("twirlCompile%s%s", StringUtils.capitalize((String)twirlSourceSet.getName()), StringUtils.capitalize((String)binary.getName()));
                final File twirlCompileOutputDirectory = this.srcOutputDirectory(buildDir, binary, twirlCompileTaskName);
                tasks.create(twirlCompileTaskName, TwirlCompile.class, (Action)new Action<TwirlCompile>(){

                    public void execute(TwirlCompile twirlCompile) {
                        twirlCompile.setDependencyNotation(TwirlCompilerFactory.createAdapter(binary.getTargetPlatform()).getDependencyNotation());
                        twirlCompile.setSource(twirlSourceSet.getSource());
                        twirlCompile.setOutputDirectory(twirlCompileOutputDirectory);
                        twirlCompile.setCompilerTool((ResolvedTool<Compiler<TwirlCompileSpec>>)compilerTool);
                        ScalaLanguageSourceSet twirlScalaSources = binary.getGeneratedScala().get(twirlSourceSet);
                        twirlScalaSources.getSource().srcDir((Object)twirlCompileOutputDirectory);
                        twirlScalaSources.builtBy(new Object[]{twirlCompile});
                    }
                });
            }
        }

        @BinaryTasks
        void createRoutesCompileTasks(CollectionBuilder<Task> tasks, final PlayApplicationBinarySpec binary, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
            ToolResolver toolResolver = (ToolResolver)serviceRegistry.get(ToolResolver.class);
            final ResolvedTool compilerTool = toolResolver.resolveCompiler(RoutesCompileSpec.class, (Platform)binary.getTargetPlatform());
            for (final RoutesSourceSet routesSourceSet : binary.getSource().withType(RoutesSourceSet.class)) {
                String routesCompileTaskName = String.format("routesCompile%s%s", StringUtils.capitalize((String)routesSourceSet.getName()), StringUtils.capitalize((String)binary.getName()));
                final File routesCompilerOutputDirectory = this.srcOutputDirectory(buildDir, binary, routesCompileTaskName);
                tasks.create(routesCompileTaskName, RoutesCompile.class, (Action)new Action<RoutesCompile>(){

                    public void execute(RoutesCompile routesCompile) {
                        routesCompile.setCompilerTool((ResolvedTool<Compiler<RoutesCompileSpec>>)compilerTool);
                        routesCompile.setAdditionalImports(new ArrayList<String>());
                        routesCompile.setSource(routesSourceSet.getSource());
                        routesCompile.setOutputDirectory(routesCompilerOutputDirectory);
                        ScalaLanguageSourceSet routesScalaSources = binary.getGeneratedScala().get(routesSourceSet);
                        routesScalaSources.getSource().srcDir((Object)routesCompilerOutputDirectory);
                        routesScalaSources.builtBy(new Object[]{routesCompile});
                    }
                });
            }
        }

        @BinaryTasks
        void createScalaCompileTask(CollectionBuilder<Task> tasks, final PlayApplicationBinarySpec binary, final @Path(value="buildDir") File buildDir) {
            final String scalaCompileTaskName = String.format("scalaCompile%s", StringUtils.capitalize((String)binary.getName()));
            tasks.create(scalaCompileTaskName, PlatformScalaCompile.class, (Action)new Action<PlatformScalaCompile>(){

                public void execute(PlatformScalaCompile scalaCompile) {
                    scalaCompile.setDestinationDir(binary.getClasses().getClassesDir());
                    scalaCompile.setPlatform(binary.getTargetPlatform().getScalaPlatform());
                    String targetCompatibility = binary.getTargetPlatform().getJavaPlatform().getTargetCompatibility().getMajorVersion();
                    scalaCompile.setSourceCompatibility(targetCompatibility);
                    scalaCompile.setTargetCompatibility(targetCompatibility);
                    IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                    incrementalOptions.setAnalysisFile(new File(buildDir, String.format("tmp/scala/compilerAnalysis/%s.analysis", scalaCompileTaskName)));
                    for (LanguageSourceSet languageSourceSet : binary.getSource().withType(ScalaLanguageSourceSet.class)) {
                        scalaCompile.source(new Object[]{languageSourceSet.getSource()});
                        scalaCompile.dependsOn(new Object[]{languageSourceSet});
                    }
                    for (LanguageSourceSet languageSourceSet : binary.getSource().withType(JavaSourceSet.class)) {
                        scalaCompile.source(new Object[]{languageSourceSet.getSource()});
                        scalaCompile.dependsOn(new Object[]{languageSourceSet});
                    }
                    for (LanguageSourceSet languageSourceSet : binary.getGeneratedScala().values()) {
                        scalaCompile.source(new Object[]{languageSourceSet.getSource()});
                        scalaCompile.dependsOn(new Object[]{languageSourceSet.getBuildDependencies()});
                    }
                    scalaCompile.setClasspath(((PlayApplicationBinarySpecInternal)binary).getClasspath());
                    binary.getClasses().builtBy(new Object[]{scalaCompile});
                }
            });
        }

        @BinaryTasks
        void createJarTasks(CollectionBuilder<Task> tasks, final PlayApplicationBinarySpec binary) {
            String jarTaskName = String.format("create%sJar", StringUtils.capitalize((String)binary.getName()));
            tasks.create(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDestinationDir(binary.getJarFile().getParentFile());
                    jar.setArchiveName(binary.getJarFile().getName());
                    jar.from(new Object[]{binary.getClasses().getClassesDir()});
                    jar.from(new Object[]{binary.getClasses().getResourceDirs()});
                    jar.dependsOn(new Object[]{binary.getClasses()});
                }
            });
            String assetsJarTaskName = String.format("create%sAssetsJar", StringUtils.capitalize((String)binary.getName()));
            tasks.create(assetsJarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDestinationDir(binary.getAssetsJarFile().getParentFile());
                    jar.setArchiveName(binary.getAssetsJarFile().getName());
                    jar.setClassifier("assets");
                    CopySpecInternal newSpec = jar.getRootSpec().addChild();
                    newSpec.from(new Object[]{binary.getAssets().getAssetDirs()});
                    newSpec.into((Object)"public");
                    jar.dependsOn(new Object[]{binary.getAssets()});
                }
            });
        }

        @Mutate
        void createPlayRunTask(CollectionBuilder<Task> tasks, BinaryContainer binaryContainer, ServiceRegistry serviceRegistry, final PlayPluginConfigurations configurations) {
            ToolResolver toolResolver = (ToolResolver)serviceRegistry.get(ToolResolver.class);
            for (final PlayApplicationBinarySpecInternal binary : binaryContainer.withType(PlayApplicationBinarySpecInternal.class)) {
                final ResolvedTool playApplicationRunnerTool = toolResolver.resolve(PlayApplicationRunner.class, (Platform)binary.getTargetPlatform());
                String runTaskName = String.format("run%s", StringUtils.capitalize((String)binary.getName()));
                tasks.create(runTaskName, PlayRun.class, (Action)new Action<PlayRun>(){

                    public void execute(PlayRun playRun) {
                        playRun.setHttpPort(9000);
                        playRun.setPlayApplicationRunnerTool((ResolvedTool<PlayApplicationRunner>)playApplicationRunnerTool);
                        playRun.setApplicationJar(binary.getJarFile());
                        playRun.setAssetsJar(binary.getAssetsJarFile());
                        playRun.setRuntimeClasspath(configurations.getPlayRun().getFileCollection());
                        playRun.dependsOn(new Object[]{binary.getBuildTask()});
                    }
                });
            }
        }

        private File srcOutputDirectory(File buildDir, PlayApplicationBinarySpec binary, String taskName) {
            return new File(buildDir, String.format("%s/src/%s", binary.getName(), taskName));
        }
    }
}

