/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import org.gradle.model.Defaults;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.distribution.PlayDistribution;
import org.gradle.play.distribution.PlayDistributionContainer;
import org.gradle.play.internal.distribution.DefaultPlayDistribution;
import org.gradle.play.internal.distribution.DefaultPlayDistributionContainer;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayDistributionPlugin
extends RuleSource {
    public static final String DISTRIBUTION_GROUP = "distribution";

    @Model
    PlayDistributionContainer distributions(ServiceRegistry serviceRegistry) {
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        return new DefaultPlayDistributionContainer(instantiator);
    }

    @Mutate
    void createLifecycleTasks(CollectionBuilder<Task> tasks) {
        tasks.create("dist", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Assembles all play distributions.");
                task.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
            }
        });
        tasks.create("stage", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.setDescription("Stages all play distributions.");
                task.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
            }
        });
    }

    @Defaults
    void createDistributions(@Path(value="distributions") PlayDistributionContainer distributions, BinaryContainer binaryContainer, PlayPluginConfigurations configurations, ServiceRegistry serviceRegistry) {
        FileOperations fileOperations = (FileOperations)serviceRegistry.get(FileOperations.class);
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        for (PlayApplicationBinarySpec binary : binaryContainer.withType(PlayApplicationBinarySpec.class)) {
            PlayDistribution distribution = (PlayDistribution)instantiator.newInstance(DefaultPlayDistribution.class, new Object[]{binary.getName(), fileOperations.copySpec(Actions.doNothing()), binary});
            distribution.setBaseName(binary.getName());
            distributions.add(distribution);
        }
    }

    @Mutate
    void createDistributionContentTasks(CollectionBuilder<Task> tasks, @Path(value="buildDir") File buildDir, @Path(value="distributions") PlayDistributionContainer distributions, final PlayPluginConfigurations configurations) {
        for (PlayDistribution distribution : distributions.withType(PlayDistribution.class)) {
            final PlayApplicationBinarySpec binary = distribution.getBinary();
            if (binary == null) {
                throw new InvalidUserCodeException(String.format("Play Distribution '%s' does not have a configured Play binary.", distribution.getName()));
            }
            final File distJarDir = new File(buildDir, String.format("distributionJars/%s", distribution.getName()));
            String jarTaskName = String.format("create%sDistributionJar", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.dependsOn(new Object[]{binary.getTasks().withType(Jar.class)});
                    jar.from(new Object[]{jar.getProject().zipTree((Object)binary.getJarFile())});
                    jar.setDestinationDir(distJarDir);
                    jar.setArchiveName(binary.getJarFile().getName());
                    HashMap classpath = Maps.newHashMap();
                    classpath.put("Class-Path", new PlayManifestClasspath(configurations.getPlayRun(), binary.getAssetsJarFile()));
                    jar.getManifest().attributes((Map)classpath);
                }
            });
            final Task distributionJar = (Task)tasks.get(jarTaskName);
            final File scriptsDir = new File(buildDir, String.format("scripts/%s", distribution.getName()));
            String createStartScriptsTaskName = String.format("create%sStartScripts", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(createStartScriptsTaskName, CreateStartScripts.class, (Action)new Action<CreateStartScripts>(){

                public void execute(CreateStartScripts createStartScripts) {
                    createStartScripts.setDescription("Creates OS specific scripts to run the play application.");
                    createStartScripts.setClasspath(distributionJar.getOutputs().getFiles());
                    createStartScripts.setMainClassName("play.core.server.NettyServer");
                    createStartScripts.setApplicationName(binary.getName());
                    createStartScripts.setOutputDir(scriptsDir);
                }
            });
            Task createStartScripts = (Task)tasks.get(createStartScriptsTaskName);
            CopySpecInternal distSpec = (CopySpecInternal)distribution.getContents();
            CopySpec libSpec = distSpec.addChild().into((Object)"lib");
            libSpec.from(new Object[]{distributionJar});
            libSpec.from(new Object[]{binary.getAssetsJarFile()});
            libSpec.from(new Object[]{configurations.getPlayRun().getFileCollection()});
            CopySpec binSpec = distSpec.addChild().into((Object)"bin");
            binSpec.from(new Object[]{createStartScripts});
            binSpec.setFileMode(Integer.valueOf(493));
            CopySpec confSpec = distSpec.addChild().into((Object)"conf");
            confSpec.from(new Object[]{"conf"}).exclude(new String[]{"routes"});
            distSpec.from(new Object[]{"README"});
        }
    }

    @Mutate
    void createDistributionZipTasks(CollectionBuilder<Task> tasks, final @Path(value="buildDir") File buildDir, PlayDistributionContainer distributions) {
        for (final PlayDistribution distribution : distributions.withType(PlayDistribution.class)) {
            final String stageTaskName = String.format("stage%sDist", StringUtils.capitalize((String)distribution.getName()));
            final File stageDir = new File(buildDir, "stage");
            final String baseName = StringUtils.isNotEmpty((String)distribution.getBaseName()) ? distribution.getBaseName() : distribution.getName();
            tasks.create(stageTaskName, Copy.class, (Action)new Action<Copy>(){

                public void execute(Copy copy) {
                    copy.setDescription("Copies the binary distribution to a staging directory.");
                    copy.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
                    copy.setDestinationDir(stageDir);
                    CopySpecInternal baseSpec = copy.getRootSpec().addChild();
                    baseSpec.into((Object)baseName);
                    baseSpec.with(new CopySpec[]{distribution.getContents()});
                }
            });
            tasks.named("stage", (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{stageTaskName});
                }
            });
            final Task stageTask = (Task)tasks.get(stageTaskName);
            final String distributionTaskName = String.format("create%sDist", StringUtils.capitalize((String)distribution.getName()));
            tasks.create(distributionTaskName, Zip.class, (Action)new Action<Zip>(){

                public void execute(Zip zip) {
                    zip.setDescription("Bundles the play binary as a distribution.");
                    zip.setGroup(PlayDistributionPlugin.DISTRIBUTION_GROUP);
                    zip.setArchiveName(String.format("%s.zip", baseName));
                    zip.setDestinationDir(new File(buildDir, "distributions"));
                    zip.from(new Object[]{stageTask});
                }
            });
            tasks.named("dist", (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{distributionTaskName});
                }
            });
        }
    }

    static class PlayManifestClasspath {
        final PlayPluginConfigurations.PlayConfiguration playConfiguration;
        final File assetsJarFile;

        public PlayManifestClasspath(PlayPluginConfigurations.PlayConfiguration playConfiguration, File assetsJarFile) {
            this.playConfiguration = playConfiguration;
            this.assetsJarFile = assetsJarFile;
        }

        public String toString() {
            Set classpathFiles = this.playConfiguration.getFileCollection().getFiles();
            classpathFiles.add(this.assetsJarFile);
            Set classpathFileNames = CollectionUtils.collect((Set)classpathFiles, (Transformer)new Transformer<String, File>(){

                public String transform(File file) {
                    return file.getName();
                }
            });
            return StringUtils.join((Collection)classpathFileNames, (String)" ");
        }
    }
}

