/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.javascript.internal.DefaultJavaScriptSourceSet;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.toolchain.ResolvedTool;
import org.gradle.platform.base.internal.toolchain.ToolResolver;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.play.tasks.JavaScriptMinify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayJavaScriptPlugin
extends RuleSource {
    @LanguageType
    void registerJavascript(LanguageTypeBuilder<JavaScriptSourceSet> builder) {
        builder.setLanguageName("javaScript");
        builder.defaultImplementation(DefaultJavaScriptSourceSet.class);
    }

    @Mutate
    void createJavascriptSourceSets(CollectionBuilder<PlayApplicationSpec> components) {
        components.beforeEach((Action)new Action<PlayApplicationSpec>(){

            public void execute(PlayApplicationSpec playComponent) {
                JavaScriptSourceSet javaScriptSourceSet = (JavaScriptSourceSet)((ComponentSpecInternal)playComponent).getSources().create("javaScriptAssets", JavaScriptSourceSet.class);
                javaScriptSourceSet.getSource().srcDir((Object)"app/assets");
                javaScriptSourceSet.getSource().include(new String[]{"**/*.js"});
            }
        });
    }

    @BinaryTasks
    void createJavaScriptTasks(CollectionBuilder<Task> tasks, PlayApplicationBinarySpec binary, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
        ToolResolver toolResolver = (ToolResolver)serviceRegistry.get(ToolResolver.class);
        ResolvedTool compilerTool = toolResolver.resolveCompiler(JavaScriptCompileSpec.class, (Platform)binary.getTargetPlatform());
        for (JavaScriptSourceSet javaScriptSourceSet : binary.getSource().withType(JavaScriptSourceSet.class)) {
            if (!((LanguageSourceSetInternal)javaScriptSourceSet).getMayHaveSources()) continue;
            this.createJavaScriptMinifyTask(tasks, javaScriptSourceSet, binary, (ResolvedTool<Compiler<JavaScriptCompileSpec>>)compilerTool, buildDir);
        }
        for (JavaScriptSourceSet javaScriptSourceSet : binary.getGeneratedJavaScript().values()) {
            this.createJavaScriptMinifyTask(tasks, javaScriptSourceSet, binary, (ResolvedTool<Compiler<JavaScriptCompileSpec>>)compilerTool, buildDir);
        }
    }

    void createJavaScriptMinifyTask(CollectionBuilder<Task> tasks, final JavaScriptSourceSet javaScriptSourceSet, final PlayApplicationBinarySpec binary, final ResolvedTool<Compiler<JavaScriptCompileSpec>> compilerTool, @Path(value="buildDir") File buildDir) {
        String minifyTaskName = "minify" + StringUtils.capitalize((String)binary.getName()) + StringUtils.capitalize((String)javaScriptSourceSet.getName());
        final File minifyOutputDirectory = new File(buildDir, String.format("%s/src/%s", binary.getName(), minifyTaskName));
        tasks.create(minifyTaskName, JavaScriptMinify.class, (Action)new Action<JavaScriptMinify>(){

            public void execute(JavaScriptMinify javaScriptMinify) {
                javaScriptMinify.setSource(javaScriptSourceSet.getSource());
                javaScriptMinify.setDestinationDir(minifyOutputDirectory);
                javaScriptMinify.setCompilerTool((ResolvedTool<Compiler<JavaScriptCompileSpec>>)compilerTool);
                binary.getAssets().builtBy(new Object[]{javaScriptMinify});
                binary.getAssets().addAssetDir(minifyOutputDirectory);
                javaScriptMinify.dependsOn(new Object[]{javaScriptSourceSet.getBuildDependencies()});
            }
        });
    }
}

