/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;

public class PlayPluginConfigurations {
    public static final String PLATFORM_CONFIGURATION = "playPlatform";
    public static final String COMPILE_CONFIGURATION = "play";
    public static final String RUN_CONFIGURATION = "playRun";
    public static final String TEST_COMPILE_CONFIGURATION = "playTest";
    private final ConfigurationContainer configurations;
    private final DependencyHandler dependencyHandler;

    public PlayPluginConfigurations(ConfigurationContainer configurations, DependencyHandler dependencyHandler) {
        this.configurations = configurations;
        this.dependencyHandler = dependencyHandler;
        Configuration playPlatform = (Configuration)configurations.create(PLATFORM_CONFIGURATION);
        Configuration playCompile = (Configuration)configurations.create(COMPILE_CONFIGURATION);
        playCompile.extendsFrom(new Configuration[]{playPlatform});
        Configuration playRun = (Configuration)configurations.create(RUN_CONFIGURATION);
        playRun.extendsFrom(new Configuration[]{playCompile});
        Configuration playTestCompile = (Configuration)configurations.create(TEST_COMPILE_CONFIGURATION);
        playTestCompile.extendsFrom(new Configuration[]{playCompile});
        ((Configuration)configurations.maybeCreate("default")).extendsFrom(new Configuration[]{playCompile});
    }

    public PlayConfiguration getPlayPlatform() {
        return new PlayConfiguration(PLATFORM_CONFIGURATION);
    }

    public PlayConfiguration getPlay() {
        return new PlayConfiguration(COMPILE_CONFIGURATION);
    }

    public PlayConfiguration getPlayRun() {
        return new PlayConfiguration(RUN_CONFIGURATION);
    }

    public PlayConfiguration getPlayTest() {
        return new PlayConfiguration(TEST_COMPILE_CONFIGURATION);
    }

    class PlayConfiguration {
        private final String name;

        PlayConfiguration(String name) {
            this.name = name;
        }

        FileCollection getFileCollection() {
            return PlayPluginConfigurations.this.configurations.getByName(this.name);
        }

        void addDependency(String notation) {
            PlayPluginConfigurations.this.dependencyHandler.add(this.name, (Object)notation);
        }

        void addArtifact(PublishArtifact artifact) {
            PlayPluginConfigurations.this.configurations.getByName(this.name).getArtifacts().add((Object)artifact);
        }
    }
}

