/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.testing.Test;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.plugins.PlayPluginConfigurations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayTestPlugin
extends RuleSource {
    @Mutate
    void createTestTasks(CollectionBuilder<Task> tasks, BinaryContainer binaryContainer, PlayPluginConfigurations configurations, FileResolver fileResolver, final ProjectIdentifier projectIdentifier, final @Path(value="buildDir") File buildDir) {
        for (final PlayApplicationBinarySpecInternal binary : binaryContainer.withType(PlayApplicationBinarySpecInternal.class)) {
            final FileCollection testCompileClasspath = this.getTestCompileClasspath(binary, configurations);
            final String testCompileTaskName = String.format("compile%sTests", StringUtils.capitalize((String)binary.getName()));
            final File testSourceDir = fileResolver.resolve((Object)"test");
            final File testClassesDir = new File(buildDir, String.format("%s/testClasses", binary.getName()));
            tasks.create(testCompileTaskName, PlatformScalaCompile.class, (Action)new Action<PlatformScalaCompile>(){

                public void execute(PlatformScalaCompile scalaCompile) {
                    scalaCompile.setClasspath(testCompileClasspath);
                    scalaCompile.dependsOn(new Object[]{binary.getBuildTask()});
                    scalaCompile.setPlatform(binary.getTargetPlatform().getScalaPlatform());
                    scalaCompile.setDestinationDir(testClassesDir);
                    scalaCompile.setSource((Object)testSourceDir);
                    String targetCompatibility = binary.getTargetPlatform().getJavaPlatform().getTargetCompatibility().getMajorVersion();
                    scalaCompile.setSourceCompatibility(targetCompatibility);
                    scalaCompile.setTargetCompatibility(targetCompatibility);
                    IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                    incrementalOptions.setAnalysisFile(new File(buildDir, String.format("tmp/scala/compilerAnalysis/%s.analysis", testCompileTaskName)));
                    binary.getTasks().add((Object)scalaCompile);
                }
            });
            final String testTaskName = String.format("test%s", StringUtils.capitalize((String)binary.getName()));
            final File binaryBuildDir = new File(buildDir, binary.getName());
            tasks.create(testTaskName, Test.class, (Action)new Action<Test>(){

                public void execute(Test test) {
                    test.setClasspath(PlayTestPlugin.this.getRuntimeClasspath(testClassesDir, testCompileClasspath));
                    test.setTestClassesDir(testClassesDir);
                    test.setBinResultsDir(new File(binaryBuildDir, String.format("results/%s/bin", testTaskName)));
                    test.getReports().getJunitXml().setDestination((Object)new File(binaryBuildDir, "reports/test/xml"));
                    test.getReports().getHtml().setDestination((Object)new File(binaryBuildDir, "reports/test"));
                    test.dependsOn(new Object[]{testCompileTaskName});
                    test.setTestSrcDirs(Arrays.asList(testSourceDir));
                    test.setWorkingDir((Object)projectIdentifier.getProjectDir());
                }
            });
            binary.getTasks().add(tasks.get(testTaskName));
        }
    }

    private FileCollection getTestCompileClasspath(PlayApplicationBinarySpec binary, PlayPluginConfigurations configurations) {
        return new SimpleFileCollection(new File[]{binary.getJarFile()}).plus(configurations.getPlayTest().getFileCollection());
    }

    private FileCollection getRuntimeClasspath(File testClassesDir, FileCollection testCompileClasspath) {
        return new SimpleFileCollection(new File[]{testClassesDir}).plus(testCompileClasspath);
    }

    @Mutate
    void attachTestSuitesToCheckTask(CollectionBuilder<Task> tasks, final BinaryContainer binaries) {
        tasks.named("check", (Action)new Action<Task>(){

            public void execute(Task checkTask) {
                for (PlayApplicationBinarySpec binary : binaries.withType(PlayApplicationBinarySpec.class)) {
                    checkTask.dependsOn(new Object[]{binary.getTasks().withType(Test.class)});
                }
            }
        });
    }
}

