/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.tasks;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.platform.base.internal.toolchain.ResolvedTool;
import org.gradle.play.internal.run.DefaultPlayRunSpec;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayApplicationRunnerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayRun
extends ConventionTask {
    private static Logger logger = LoggerFactory.getLogger(PlayRun.class);
    private int httpPort;
    @InputFile
    private File applicationJar;
    @InputFile
    private File assetsJar;
    @InputFiles
    private FileCollection runtimeClasspath;
    private BaseForkOptions forkOptions;
    private PlayApplicationRunnerToken runnerToken;
    private ResolvedTool<PlayApplicationRunner> playApplicationRunnerTool;

    public BaseForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new BaseForkOptions();
        }
        return this.forkOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void run() {
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)this.getServices().get(ProgressLoggerFactory.class);
        ProgressLogger progressLogger = progressLoggerFactory.newOperation(PlayRun.class).start("Start Play server", "Starting Play");
        int httpPort = this.getHttpPort();
        SimpleFileCollection applicationJars = new SimpleFileCollection(new File[]{this.applicationJar, this.assetsJar});
        applicationJars = applicationJars.plus(this.runtimeClasspath);
        DefaultPlayRunSpec spec = new DefaultPlayRunSpec((FileCollection)applicationJars, this.getProject().getProjectDir(), this.getForkOptions(), httpPort);
        try {
            this.runnerToken = ((PlayApplicationRunner)this.playApplicationRunnerTool.get()).start(spec);
            progressLogger.completed();
            progressLogger = progressLoggerFactory.newOperation(PlayRun.class).start(String.format("Run Play App at http://localhost:%d/", httpPort), String.format("Running at http://localhost:%d/ (stop with ctrl+d)", httpPort));
            this.waitForCtrlD();
            this.runnerToken.stop();
        }
        finally {
            progressLogger.completed();
        }
    }

    private void waitForCtrlD() {
        try {
            int c;
            while ((c = System.in.read()) != -1 && c != 4) {
            }
            logger.info("received end of stream (ctrl+d)");
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setApplicationJar(File applicationJar) {
        this.applicationJar = applicationJar;
    }

    public void setAssetsJar(File assetsJar) {
        this.assetsJar = assetsJar;
    }

    public void setRuntimeClasspath(FileCollection runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }

    public void setPlayApplicationRunnerTool(ResolvedTool<PlayApplicationRunner> playApplicationRunnerTool) {
        this.playApplicationRunnerTool = playApplicationRunnerTool;
    }
}

