/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.platform.base.internal.toolchain.ResolvedTool;
import org.gradle.play.internal.CleaningPlayToolCompiler;
import org.gradle.play.internal.routes.DefaultRoutesCompileSpec;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.toolchain.PlayToolChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class RoutesCompile
extends SourceTask {
    private File outputDirectory;
    private List<String> additionalImports = new ArrayList<String>();
    private boolean javaProject;
    private boolean namespaceReverseRouter;
    private BaseForkOptions forkOptions;
    private ResolvedTool<Compiler<RoutesCompileSpec>> compilerTool;

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<String> getAdditionalImports() {
        return this.additionalImports;
    }

    public void setAdditionalImports(List<String> additionalImports) {
        this.additionalImports.addAll(additionalImports);
    }

    @TaskAction
    void compile() {
        DefaultRoutesCompileSpec spec = new DefaultRoutesCompileSpec(this.getSource().getFiles(), this.getOutputDirectory(), this.getForkOptions(), this.isJavaProject());
        new CleaningPlayToolCompiler<DefaultRoutesCompileSpec>((Compiler)this.compilerTool.get(), this.getOutputs()).execute(spec);
    }

    public void setCompilerTool(ResolvedTool<Compiler<RoutesCompileSpec>> compilerTool) {
        this.compilerTool = compilerTool;
    }

    public boolean isJavaProject() {
        return this.javaProject;
    }

    @Incubating
    @Inject
    public PlayToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    public BaseForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new BaseForkOptions();
        }
        return this.forkOptions;
    }
}

