/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.scala.internal.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaMethod {
    private final String description;
    private final Method method;
    private final Object instance;

    public ScalaMethod(ClassLoader classLoader, String className, String methodName, Class<?> ... typeParameters) {
        this.description = String.format("%s.%s()", className, methodName);
        Class<?> baseClass = this.getClass(classLoader, className);
        Field scalaObject = this.getModule(baseClass);
        this.instance = this.getInstance(scalaObject);
        this.method = this.getMethod(scalaObject.getType(), methodName, typeParameters);
    }

    private Method getMethod(Class<?> type, String methodName, Class<?>[] typeParameters) {
        try {
            return type.getMethod(methodName, typeParameters);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Object getInstance(Field scalaObject) {
        try {
            return scalaObject.get(null);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Class<?> getClass(ClassLoader classLoader, String typeName) {
        try {
            return classLoader.loadClass(typeName + "$");
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Field getModule(Class<?> baseClass) {
        try {
            return baseClass.getField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public Object invoke(Object ... args) {
        try {
            return this.method.invoke(this.instance, args);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not invoke Scala method %s.", this.description), (Throwable)e);
        }
    }
}

