/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManifestMergeFailureParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR1 = Pattern.compile("\\[([^:].[^:]+):(\\d+)\\] (.+)");
    private static final Pattern ERROR2 = Pattern.compile("([^:].[^:]+):(\\d+):(\\d+) (.+):");

    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m = ERROR1.matcher(line);
        if (m.matches()) {
            int lineNumber;
            String sourcePath = m.group(1);
            try {
                lineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            String message = m.group(3);
            messages.add(new Message(Message.Kind.ERROR, message, new SourceFilePosition(new File(sourcePath), new SourcePosition(lineNumber - 1, -1, -1)), new SourceFilePosition[0]));
            return true;
        }
        m = ERROR2.matcher(line);
        if (m.matches()) {
            int column;
            int lineNumber;
            String sourcePath = ManifestMergeFailureParser.removeLeadingTab(m.group(1)).trim();
            try {
                lineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            try {
                column = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            if (lineNumber == 0 && column == 0) {
                String next = reader.peek(0);
                if (next != null && next.contains("Validation failed, exiting")) {
                    reader.readLine();
                    return true;
                }
            } else {
                String msg = reader.readLine();
                if (msg != null) {
                    msg = ManifestMergeFailureParser.removeLeadingTab(msg).trim();
                    Message.Kind kind = Message.Kind.findIgnoringCase((String)m.group(4), (Message.Kind)Message.Kind.ERROR);
                    messages.add(new Message(kind, msg.trim(), new SourceFilePosition(new File(sourcePath), new SourcePosition(lineNumber - 1, column - 1, -1)), new SourceFilePosition[0]));
                    return true;
                }
            }
        }
        return false;
    }

    private static String removeLeadingTab(String s) {
        if (s.startsWith("\t") && s.length() > 1) {
            return s.substring(1);
        }
        return s;
    }
}

