/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.build.SymbolLoader;
import com.android.sdklib.internal.build.SymbolWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.annotations.NonNls;

public final class AndroidApt {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidApt");
    @NonNls
    private static final String COMMAND_CRUNCH = "crunch";
    @NonNls
    private static final String COMMAND_PACKAGE = "package";
    private static final FileFilter PNG_FILES_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || FileUtilRt.extensionEquals((String)file.getName(), (String)"png");
        }
    };

    private AndroidApt() {
    }

    public static Map<AndroidCompilerMessageKind, List<String>> compile(IAndroidTarget target, int platformToolsRevision, String manifestFileOsPath, String aPackage, String outDirOsPath, String[] resourceDirsOsPaths, String[] extraPackages, boolean nonConstantFields, String proguardCfgOutputFileOsPath) throws IOException {
        ArrayList<Pair<String, String>> libRTxtFilesAndPackages = new ArrayList<Pair<String, String>>();
        for (String extraPackage : extraPackages) {
            libRTxtFilesAndPackages.add(Pair.create((Object)null, (Object)extraPackage));
        }
        return AndroidApt.compile(target, platformToolsRevision, manifestFileOsPath, aPackage, outDirOsPath, resourceDirsOsPaths, libRTxtFilesAndPackages, nonConstantFields, proguardCfgOutputFileOsPath, null, false);
    }

    public static Map<AndroidCompilerMessageKind, List<String>> compile(IAndroidTarget target, int platformToolsRevision, String manifestFileOsPath, String aPackage, String outDirOsPath, String[] resourceDirsOsPaths, List<Pair<String, String>> libRTxtFilesAndPackages, boolean nonConstantFields, String proguardCfgOutputFileOsPath, String rTxtOutDirOsPath, boolean optimizeRFile) throws IOException {
        File rJavaFile;
        String packageFolderOsPath;
        File manifestJavaFile;
        HashMap messages = new HashMap();
        messages.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        File outOsDir = new File(outDirOsPath);
        if (!outOsDir.exists() && !outOsDir.mkdirs()) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to create directory " + outDirOsPath);
        }
        if ((manifestJavaFile = new File((packageFolderOsPath = FileUtil.toSystemDependentName((String)(outDirOsPath + '/' + aPackage.replace('.', '/')))) + File.separatorChar + "Manifest.java")).exists() && !FileUtil.delete((File)manifestJavaFile)) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to delete " + manifestJavaFile.getPath());
        }
        if ((rJavaFile = new File(packageFolderOsPath + File.separatorChar + "R.java")).exists() && !FileUtil.delete((File)rJavaFile)) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to delete " + rJavaFile.getPath());
        }
        File[] extraRJavaFiles = new File[libRTxtFilesAndPackages.size()];
        int n = libRTxtFilesAndPackages.size();
        for (int i = 0; i < n; ++i) {
            String libPackage = (String)libRTxtFilesAndPackages.get(i).getSecond();
            String libPackageFolderOsPath = FileUtil.toSystemDependentName((String)(outDirOsPath + '/' + libPackage.replace('.', '/')));
            extraRJavaFiles[i] = new File(libPackageFolderOsPath + File.separatorChar + "R.java");
        }
        for (File extraRJavaFile : extraRJavaFiles) {
            if (!extraRJavaFile.exists() || FileUtil.delete((File)extraRJavaFile)) continue;
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to delete " + extraRJavaFile.getPath());
        }
        if (platformToolsRevision < 0 || platformToolsRevision > 7) {
            Map<AndroidCompilerMessageKind, List<String>> map = AndroidApt.doCompile(target, manifestFileOsPath, outDirOsPath, resourceDirsOsPaths, libRTxtFilesAndPackages, null, nonConstantFields, proguardCfgOutputFileOsPath, rTxtOutDirOsPath, optimizeRFile);
            if (map.get((Object)AndroidCompilerMessageKind.ERROR).isEmpty()) {
                AndroidApt.makeFieldsNotFinal(extraRJavaFiles);
            }
            AndroidExecutionUtil.addMessages(messages, map);
            return messages;
        }
        ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("'Platform Tools' package is out of date. Please update it through Android SDK manager");
        return messages;
    }

    private static void makeFieldsNotFinal(File[] libRJavaFiles) throws IOException {
        for (File file : libRJavaFiles) {
            if (!file.isFile()) continue;
            String fileContent = AndroidCommonUtils.readFile(file);
            FileUtil.writeToFile((File)file, (String)fileContent.replace("public static final int ", "public static int "));
        }
    }

    private static Map<AndroidCompilerMessageKind, List<String>> doCompile(IAndroidTarget target, String manifestFileOsPath, String outDirOsPath, String[] resourceDirsOsPaths, List<Pair<String, String>> libRTxtFilesAndPackages, String customPackage, boolean nonConstantIds, String proguardCfgOutputFileOsPath, String rTxtOutDirOsPath, boolean optimizeRFile) throws IOException {
        File rFile;
        ArrayList<String> args = new ArrayList<String>();
        BuildToolInfo buildToolInfo = target.getBuildToolInfo();
        if (buildToolInfo == null) {
            return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
        }
        args.add(buildToolInfo.getPath(BuildToolInfo.PathId.AAPT));
        args.add(COMMAND_PACKAGE);
        args.add("-m");
        if (nonConstantIds) {
            args.add("--non-constant-id");
        }
        if (resourceDirsOsPaths.length > 1) {
            args.add("--auto-add-overlay");
        }
        HashSet extraPackages = new HashSet();
        for (Pair<String, String> pair : libRTxtFilesAndPackages) {
            extraPackages.add(pair.getSecond());
        }
        if (extraPackages.size() > 0) {
            args.add("--extra-packages");
            args.add(AndroidApt.toPackagesString(ArrayUtil.toStringArray((Collection)extraPackages)));
        }
        if (customPackage != null) {
            args.add("--custom-package");
            args.add(customPackage);
        }
        if (rTxtOutDirOsPath != null) {
            args.add("--output-text-symbols");
            args.add(rTxtOutDirOsPath);
        }
        args.add("-J");
        args.add(outDirOsPath);
        args.add("-M");
        args.add(manifestFileOsPath);
        for (String libResFolderOsPath : resourceDirsOsPaths) {
            args.add("-S");
            args.add(libResFolderOsPath);
        }
        args.add("-I");
        args.add(target.getPath(1));
        if (proguardCfgOutputFileOsPath != null) {
            args.add("-G");
            args.add(proguardCfgOutputFileOsPath);
        }
        Map<AndroidCompilerMessageKind, List<String>> messages = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(args));
        LOG.info(AndroidCommonUtils.command2string(args));
        if (messages.get((Object)AndroidCompilerMessageKind.ERROR).size() > 0) {
            return messages;
        }
        if (optimizeRFile && !libRTxtFilesAndPackages.isEmpty() && rTxtOutDirOsPath != null && (rFile = new File(rTxtOutDirOsPath, "R.txt")).isFile()) {
            SymbolLoader fullSymbolValues = new SymbolLoader(rFile);
            fullSymbolValues.load();
            MultiMap libMap = new MultiMap();
            for (Pair<String, String> pair : libRTxtFilesAndPackages) {
                File rTextFile = new File((String)pair.getFirst());
                String libPackage = (String)pair.getSecond();
                if (!rTextFile.isFile()) continue;
                SymbolLoader libSymbols = new SymbolLoader(rTextFile);
                libSymbols.load();
                libMap.putValue((Object)libPackage, (Object)libSymbols);
            }
            for (Map.Entry entry : libMap.entrySet()) {
                String libPackage = (String)entry.getKey();
                Collection symbols = (Collection)entry.getValue();
                SymbolWriter writer = new SymbolWriter(outDirOsPath, libPackage, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
        return messages;
    }

    private static String toPackagesString(String[] packages) {
        StringBuilder builder = new StringBuilder();
        int n = packages.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append(':');
            }
            builder.append(packages[i]);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<AndroidCompilerMessageKind, List<String>> crunch(IAndroidTarget target, List<String> resPaths, String outputPath) throws IOException {
        Map<AndroidCompilerMessageKind, List<String>> map;
        block8: {
            BuildToolInfo buildToolInfo = target.getBuildToolInfo();
            if (buildToolInfo == null) {
                return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(buildToolInfo.getPath(BuildToolInfo.PathId.AAPT));
            args.add(COMMAND_CRUNCH);
            File tempDir = null;
            try {
                if (resPaths.size() > 0) {
                    if (resPaths.size() == 1) {
                        args.add("-S");
                        args.add(resPaths.get(0));
                    } else {
                        tempDir = FileUtil.createTempDirectory((String)"android_combined_resources", (String)"tmp");
                        for (int i = resPaths.size() - 1; i >= 0; --i) {
                            String resDirPath = resPaths.get(i);
                            File resDir = new File(resDirPath);
                            if (!resDir.exists()) continue;
                            FileUtil.copyDir((File)resDir, (File)tempDir, (FileFilter)PNG_FILES_FILTER);
                        }
                        args.add("-S");
                        args.add(tempDir.getPath());
                    }
                }
                args.add("-C");
                args.add(outputPath);
                LOG.info(AndroidCommonUtils.command2string(args));
                map = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(args));
                if (tempDir == null) break block8;
            }
            catch (Throwable throwable) {
                if (tempDir != null) {
                    FileUtil.delete(tempDir);
                }
                throw throwable;
            }
            FileUtil.delete((File)tempDir);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<AndroidCompilerMessageKind, List<String>> packageResources(IAndroidTarget target, int platformToolsRevision, String manifestPath, String[] resPaths, String[] osAssetDirPaths, String outputPath, String configFilter, boolean debugMode, int versionCode, String customManifestPackage, String additionalParameters, FileFilter assetsFilter) throws IOException {
        Map<AndroidCompilerMessageKind, List<String>> map;
        block18: {
            for (String resDirPath : resPaths) {
                if (!FileUtil.isAncestor((String)resDirPath, (String)outputPath, (boolean)false)) continue;
                throw new IOException("Resource directory " + FileUtil.toSystemDependentName((String)resDirPath) + " contains output " + FileUtil.toSystemDependentName((String)outputPath));
            }
            for (String assetsDirPath : osAssetDirPaths) {
                if (!FileUtil.isAncestor((String)assetsDirPath, (String)outputPath, (boolean)false)) continue;
                throw new IOException("Assets directory " + FileUtil.toSystemDependentName((String)assetsDirPath) + " contains output " + FileUtil.toSystemDependentName((String)outputPath));
            }
            BuildToolInfo buildToolInfo = target.getBuildToolInfo();
            if (buildToolInfo == null) {
                return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(buildToolInfo.getPath(BuildToolInfo.PathId.AAPT));
            args.add(COMMAND_PACKAGE);
            for (String path : resPaths) {
                args.add("-S");
                args.add(path);
            }
            args.add("-f");
            if (platformToolsRevision < 0 || platformToolsRevision > 7) {
                args.add("--no-crunch");
            }
            if (resPaths.length > 1) {
                args.add("--auto-add-overlay");
            }
            if (debugMode) {
                args.add("--debug-mode");
            }
            if (versionCode > 0) {
                args.add("--version-code");
                args.add(Integer.toString(versionCode));
            }
            if (configFilter != null) {
                args.add("-c");
                args.add(configFilter);
            }
            args.add("-M");
            args.add(manifestPath);
            File tempDir = null;
            try {
                String[] nonEmptyAssetDirs;
                if (osAssetDirPaths.length > 0 && (nonEmptyAssetDirs = AndroidApt.getNonEmptyExistingDirs(osAssetDirPaths)).length > 0) {
                    if (nonEmptyAssetDirs.length == 1) {
                        args.add("-A");
                        args.add(nonEmptyAssetDirs[0]);
                    } else {
                        tempDir = FileUtil.createTempDirectory((String)"android_combined_assets", (String)"tmp");
                        for (int i = nonEmptyAssetDirs.length - 1; i >= 0; --i) {
                            String assetDir = nonEmptyAssetDirs[i];
                            FileUtil.copyDir((File)new File(assetDir), (File)tempDir, (FileFilter)assetsFilter);
                        }
                        args.add("-A");
                        args.add(tempDir.getPath());
                    }
                }
                args.add("-I");
                args.add(target.getPath(1));
                if (customManifestPackage != null) {
                    args.add("--rename-manifest-package");
                    args.add(customManifestPackage);
                }
                if (additionalParameters != null && additionalParameters.length() > 0) {
                    args.addAll(ParametersListUtil.parse((String)additionalParameters));
                }
                args.add("-F");
                args.add(outputPath);
                LOG.info(AndroidCommonUtils.command2string(args));
                map = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(args));
                if (tempDir == null) break block18;
            }
            catch (Throwable throwable) {
                if (tempDir != null) {
                    FileUtil.delete(tempDir);
                }
                throw throwable;
            }
            FileUtil.delete((File)tempDir);
        }
        return map;
    }

    private static String[] getNonEmptyExistingDirs(String[] dirs) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dirPath : dirs) {
            File[] children;
            File dir = new File(dirPath);
            if (!dir.isDirectory() || (children = dir.listFiles()) == null || children.length <= 0) continue;
            result.add(dirPath);
        }
        return ArrayUtil.toStringArray(result);
    }
}

