/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.SdkConstants;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.execution.ParametersListUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import org.jetbrains.android.AndroidCommonBundle;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.BufferingFileWrapper;
import org.jetbrains.android.util.SafeSignedJarBuilder;
import org.jetbrains.annotations.NonNls;

public class AndroidCommonUtils {
    @NonNls
    public static final String PROGUARD_CFG_FILE_NAME = "proguard-project.txt";
    public static final String SDK_HOME_MACRO = "%MODULE_SDK_HOME%";
    public static final String PROGUARD_SYSTEM_CFG_FILE_URL = "file://%MODULE_SDK_HOME%/tools/proguard/proguard-android.txt";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidCommonUtils");
    @NonNls
    public static final String MANIFEST_JAVA_FILE_NAME = "Manifest.java";
    @NonNls
    public static final String R_JAVA_FILENAME = "R.java";
    @NonNls
    public static final String CLASSES_JAR_FILE_NAME = "classes.jar";
    @NonNls
    public static final String AAR_DEPS_JAR_FILE_NAME = "aar_deps.jar";
    @NonNls
    public static final String CLASSES_FILE_NAME = "classes.dex";
    private static final Pattern WARNING_PATTERN = Pattern.compile(".*warning.*");
    private static final Pattern ERROR_PATTERN = Pattern.compile(".*error.*");
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile(".*exception.*");
    public static final Pattern R_PATTERN = Pattern.compile("R(\\$.*)?\\.class");
    private static final Pattern MANIFEST_PATTERN = Pattern.compile("Manifest(\\$.*)?\\.class");
    private static final String BUILD_CONFIG_CLASS_NAME = "BuildConfig.class";
    public static final Pattern COMPILER_MESSAGE_PATTERN = Pattern.compile("(.+):(\\d+):.+");
    @NonNls
    public static final String PNG_EXTENSION = "png";
    private static final String[] DRAWABLE_EXTENSIONS = new String[]{"png", "jpg", "gif"};
    @NonNls
    public static final String RELEASE_BUILD_OPTION = "RELEASE_BUILD_KEY";
    @NonNls
    public static final String PROGUARD_CFG_PATHS_OPTION = "ANDROID_PROGUARD_CFG_PATHS";
    @NonNls
    public static final String DIRECTORY_FOR_LOGS_NAME = "proguard_logs";
    @NonNls
    public static final String PROGUARD_OUTPUT_JAR_NAME = "obfuscated_sources.jar";
    @NonNls
    public static final String SYSTEM_PROGUARD_CFG_FILE_NAME = "proguard-android.txt";
    @NonNls
    private static final String PROGUARD_HOME_ENV_VARIABLE = "PROGUARD_HOME";
    public static final ResourceType[] ID_PROVIDING_RESOURCE_TYPES = new ResourceType[]{ResourceType.LAYOUT, ResourceType.MENU, ResourceType.DRAWABLE, ResourceType.XML, ResourceType.TRANSITION};
    @NonNls
    public static final String INCLUDE_ASSETS_FROM_LIBRARIES_ELEMENT_NAME = "includeAssetsFromLibraries";
    @NonNls
    public static final String ADDITIONAL_NATIVE_LIBS_ELEMENT = "additionalNativeLibs";
    @NonNls
    public static final String ITEM_ELEMENT = "item";
    @NonNls
    public static final String ARCHITECTURE_ATTRIBUTE = "architecture";
    @NonNls
    public static final String URL_ATTRIBUTE = "url";
    @NonNls
    public static final String TARGET_FILE_NAME_ATTRIBUTE = "targetFileName";
    private static final String[] TEST_CONFIGURATION_TYPE_IDS = new String[]{"JUnit", "TestNG", "ScalaTestRunConfiguration", "SpecsRunConfiguration", "Specs2RunConfiguration"};
    @NonNls
    public static final String ANNOTATIONS_JAR_RELATIVE_PATH = "/tools/support/annotations.jar";
    @NonNls
    public static final String PACKAGE_MANIFEST_ATTRIBUTE = "package";
    @NonNls
    public static final String ANDROID_FINAL_PACKAGE_FOR_ARTIFACT_SUFFIX = ".afp";
    @NonNls
    public static final String PROGUARD_CFG_OUTPUT_FILE_NAME = "proguard.txt";
    @NonNls
    public static final String MANIFEST_MERGING_BUILD_TARGET_TYPE_ID = "android-manifest-merging";
    @NonNls
    public static final String AAR_DEPS_BUILD_TARGET_TYPE_ID = "android-aar-deps";
    @NonNls
    public static final String DEX_BUILD_TARGET_TYPE_ID = "android-dex";
    @NonNls
    public static final String PRE_DEX_BUILD_TARGET_TYPE_ID = "android-pre-dex";
    @NonNls
    public static final String PACKAGING_BUILD_TARGET_TYPE_ID = "android-packaging";
    @NonNls
    public static final String RESOURCE_CACHING_BUILD_TARGET_ID = "android-resource-caching";
    @NonNls
    public static final String RESOURCE_PACKAGING_BUILD_TARGET_ID = "android-resource-packaging";
    @NonNls
    public static final String LIBRARY_PACKAGING_BUILD_TARGET_ID = "android-library-packaging";
    @NonNls
    public static final String AUTOGENERATED_JAVA_FILE_HEADER = "/*___Generated_by_IDEA___*/";
    @NonNls
    public static final String ANDROID_TEST_RUN_CONFIGURATION_TYPE = "AndroidTestRunConfigurationType";

    private AndroidCommonUtils() {
    }

    public static boolean isTestConfiguration(String typeId) {
        return ArrayUtil.find((Object[])TEST_CONFIGURATION_TYPE_IDS, (Object)typeId) >= 0;
    }

    public static boolean isInstrumentationTestConfiguration(String typeId) {
        return ANDROID_TEST_RUN_CONFIGURATION_TYPE.equals(typeId);
    }

    public static String command2string(Collection<String> command) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = command.iterator();
        while (it.hasNext()) {
            String s = it.next();
            builder.append('[');
            builder.append(s);
            builder.append(']');
            if (!it.hasNext()) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static void moveAllFiles(File from, File to, Collection<File> newFiles) throws IOException {
        if (from.isFile()) {
            FileUtil.rename((File)from, (File)to);
            newFiles.add(to);
        } else {
            File[] children = from.listFiles();
            if (children != null) {
                for (File child : children) {
                    AndroidCommonUtils.moveAllFiles(child, new File(to, child.getName()), newFiles);
                }
            }
        }
    }

    public static void handleDexCompilationResult(Process process, String outputFilePath, final Map<AndroidCompilerMessageKind, List<String>> messages) {
        BaseOSProcessHandler handler = new BaseOSProcessHandler(process, null, null);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private AndroidCompilerMessageKind myCategory = null;

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String[] msgs;
                for (String msg : msgs = event.getText().split("\\n")) {
                    msg = msg.trim();
                    String msglc = msg.toLowerCase();
                    if (outputType == ProcessOutputTypes.STDERR) {
                        if (WARNING_PATTERN.matcher(msglc).matches()) {
                            this.myCategory = AndroidCompilerMessageKind.WARNING;
                        }
                        if (ERROR_PATTERN.matcher(msglc).matches() || EXCEPTION_PATTERN.matcher(msglc).matches() || this.myCategory == null) {
                            this.myCategory = AndroidCompilerMessageKind.ERROR;
                        }
                        ((List)messages.get((Object)this.myCategory)).add(msg);
                    } else if (outputType == ProcessOutputTypes.STDOUT && !msglc.startsWith("processing")) {
                        ((List)messages.get((Object)AndroidCompilerMessageKind.INFORMATION)).add(msg);
                    }
                    LOG.debug(msg);
                }
            }
        });
        handler.startNotify();
        handler.waitFor();
        List<String> errors = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        if (new File(outputFilePath).isFile()) {
            messages.get((Object)AndroidCompilerMessageKind.WARNING).addAll(errors);
            errors.clear();
        } else if (errors.size() == 0) {
            errors.add("Cannot create classes.dex file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List<String> packClassFilesIntoJar(String[] firstPackageDirPaths, String[] libFirstPackageDirPaths, File jarFile) throws IOException {
        void var6_11;
        File firstPackageDir;
        String path;
        void var6_9;
        ArrayList<Pair<File, String>> files = new ArrayList<Pair<File, String>>();
        String[] arr$ = firstPackageDirPaths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_9 < len$) {
            path = arr$[var6_9];
            firstPackageDir = new File(path);
            if (firstPackageDir.exists()) {
                AndroidCommonUtils.packClassFilesIntoJar(firstPackageDir, firstPackageDir.getParentFile(), true, files);
            }
            ++var6_9;
        }
        arr$ = libFirstPackageDirPaths;
        len$ = arr$.length;
        boolean bl2 = false;
        while (var6_11 < len$) {
            path = arr$[var6_11];
            firstPackageDir = new File(path);
            if (firstPackageDir.exists()) {
                AndroidCommonUtils.packClassFilesIntoJar(firstPackageDir, firstPackageDir.getParentFile(), false, files);
            }
            ++var6_11;
        }
        if (files.size() > 0) {
            JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
            try {
                for (Pair pair : files) {
                    AndroidCommonUtils.packIntoJar(jos, (File)pair.getFirst(), (String)pair.getSecond());
                }
            }
            finally {
                jos.close();
            }
        } else if (jarFile.isFile() && !jarFile.delete()) {
            throw new IOException("Cannot delete file " + FileUtil.toSystemDependentName((String)jarFile.getPath()));
        }
        ArrayList<String> srcFiles = new ArrayList<String>();
        for (Pair pair : files) {
            srcFiles.add(((File)pair.getFirst()).getPath());
        }
        return srcFiles;
    }

    private static void packClassFilesIntoJar(File file, File rootDirectory, boolean packRAndManifestClasses, List<Pair<File, String>> files) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    AndroidCommonUtils.packClassFilesIntoJar(child, rootDirectory, packRAndManifestClasses, files);
                }
            }
        } else if (file.isFile()) {
            if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"class")) {
                return;
            }
            if (!packRAndManifestClasses && (R_PATTERN.matcher(file.getName()).matches() || MANIFEST_PATTERN.matcher(file.getName()).matches() || BUILD_CONFIG_CLASS_NAME.equals(file.getName()))) {
                return;
            }
            String rootPath = rootDirectory.getAbsolutePath();
            String path = file.getAbsolutePath();
            if ((path = FileUtil.toSystemIndependentName((String)path.substring(rootPath.length()))).charAt(0) == '/') {
                path = path.substring(1);
            }
            files.add((Pair<File, String>)Pair.create((Object)file, (Object)path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packIntoJar(JarOutputStream jar, File file, String path) throws IOException {
        JarEntry entry = new JarEntry(path);
        entry.setTime(file.lastModified());
        jar.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            int count;
            byte[] buffer = new byte[1024];
            while ((count = bis.read(buffer)) != -1) {
                jar.write(buffer, 0, count);
            }
            jar.closeEntry();
        }
        finally {
            bis.close();
        }
    }

    public static String getResourceTypeByDirName(String name) {
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
        return folderType != null ? folderType.getName() : null;
    }

    public static String getResourceName(String resourceType, String fileName) {
        String s = FileUtil.getNameWithoutExtension((String)fileName);
        return resourceType.equals("drawable") && s.endsWith(".9") && FileUtilRt.extensionEquals((String)fileName, (String)PNG_EXTENSION) ? s.substring(0, s.length() - 2) : s;
    }

    public static String getResourceTypeByTagName(String tagName) {
        if (tagName.equals("declare-styleable")) {
            tagName = "styleable";
        } else if (tagName.endsWith("-array")) {
            tagName = "array";
        }
        return tagName;
    }

    public static Map<AndroidCompilerMessageKind, List<String>> launchProguard(IAndroidTarget target, int sdkToolsRevision, String sdkOsPath, String javaExecutablePath, String proguardVmOptions, String[] proguardConfigFileOsPaths, String inputJarOsPath, String[] externalJarOsPaths, String[] providedJarOsPaths, String outputJarFileOsPath, String logDirOutputOsPath) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaExecutablePath);
        if (proguardVmOptions.length() > 0) {
            commands.addAll(ParametersListUtil.parse((String)proguardVmOptions));
        }
        commands.add("-jar");
        String proguardHome = AndroidCommonUtils.getProguardHomeDirOsPath(sdkOsPath);
        String proguardJarOsPath = proguardHome + File.separator + "lib" + File.separator + "proguard.jar";
        commands.add(proguardJarOsPath);
        if (AndroidCommonUtils.isIncludingInProguardSupported(sdkToolsRevision)) {
            for (String proguardConfigFileOsPath : proguardConfigFileOsPaths) {
                commands.add("-include");
                commands.add(AndroidCommonUtils.quotePath(proguardConfigFileOsPath));
            }
        } else {
            commands.add("@" + AndroidCommonUtils.quotePath(proguardConfigFileOsPaths[0]));
        }
        commands.add("-injars");
        StringBuilder builder = new StringBuilder(AndroidCommonUtils.quotePath(inputJarOsPath));
        for (String jarFile : externalJarOsPaths) {
            builder.append(File.pathSeparatorChar);
            builder.append(AndroidCommonUtils.quotePath(jarFile));
        }
        commands.add(builder.toString());
        commands.add("-outjars");
        commands.add(AndroidCommonUtils.quotePath(outputJarFileOsPath));
        commands.add("-libraryjars");
        builder = new StringBuilder(AndroidCommonUtils.quotePath(target.getPath(1)));
        List libraries = target.getAdditionalLibraries();
        for (IAndroidTarget.OptionalLibrary lib : libraries) {
            builder.append(File.pathSeparatorChar);
            builder.append(AndroidCommonUtils.quotePath(lib.getJar().getAbsolutePath()));
        }
        for (String path : providedJarOsPaths) {
            builder.append(File.pathSeparatorChar);
            builder.append(AndroidCommonUtils.quotePath(path));
        }
        commands.add(builder.toString());
        if (logDirOutputOsPath != null) {
            commands.add("-dump");
            commands.add(AndroidCommonUtils.quotePath(new File(logDirOutputOsPath, "dump.txt").getAbsolutePath()));
            commands.add("-printseeds");
            commands.add(AndroidCommonUtils.quotePath(new File(logDirOutputOsPath, "seeds.txt").getAbsolutePath()));
            commands.add("-printusage");
            commands.add(AndroidCommonUtils.quotePath(new File(logDirOutputOsPath, "usage.txt").getAbsolutePath()));
            commands.add("-printmapping");
            commands.add(AndroidCommonUtils.quotePath(new File(logDirOutputOsPath, "mapping.txt").getAbsolutePath()));
        }
        LOG.info(AndroidCommonUtils.command2string(commands));
        Map home = System.getenv().containsKey(PROGUARD_HOME_ENV_VARIABLE) ? Collections.emptyMap() : Collections.singletonMap(PROGUARD_HOME_ENV_VARIABLE, proguardHome);
        return AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(commands), home);
    }

    public static String getProguardHomeDirOsPath(String sdkOsPath) {
        return sdkOsPath + File.separator + "tools" + File.separator + "proguard";
    }

    public static String getProguardHomeDirPath(String sdkOsPath) {
        return FileUtil.toSystemIndependentName((String)AndroidCommonUtils.getProguardHomeDirOsPath(sdkOsPath));
    }

    public static String getProguardSystemCfgPath(String sdkOsPath) {
        return AndroidCommonUtils.getProguardHomeDirPath(sdkOsPath) + '/' + SYSTEM_PROGUARD_CFG_FILE_NAME;
    }

    private static String quotePath(String path) {
        if (path.indexOf(32) != -1) {
            path = '\'' + path + '\'';
        }
        return path;
    }

    public static String buildTempInputJar(String[] classFilesDirOsPaths, String[] libClassFilesDirOsPaths) throws IOException {
        File inputJar = FileUtil.createTempFile((String)"proguard_input", (String)".jar");
        AndroidCommonUtils.packClassFilesIntoJar(classFilesDirOsPaths, libClassFilesDirOsPaths, inputJar);
        return FileUtil.toSystemDependentName((String)inputJar.getPath());
    }

    public static String toolPath(String toolFileName) {
        return SdkConstants.OS_SDK_TOOLS_FOLDER + toolFileName;
    }

    public static String platformToolPath(String toolFileName) {
        return SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + toolFileName;
    }

    public static boolean isIncludingInProguardSupported(int sdkToolsRevision) {
        return sdkToolsRevision == -1 || sdkToolsRevision >= 17;
    }

    public static int parsePackageRevision(String sdkDirOsPath, String packageDirName) {
        File propFile = new File(sdkDirOsPath + File.separatorChar + packageDirName + File.separatorChar + "source.properties");
        int revisionNumber = -1;
        if (propFile.exists() && propFile.isFile()) {
            Map map = ProjectProperties.parsePropertyFile((IAbstractFile)new BufferingFileWrapper(propFile), (ILogger)new MessageBuildingSdkLog());
            if (map == null) {
                return -1;
            }
            String revision = (String)map.get("Pkg.Revision");
            if (revision != null) {
                int dot = revision.indexOf(46);
                if (dot > 0) {
                    revision = revision.substring(0, dot);
                }
                try {
                    revisionNumber = Integer.parseInt(revision);
                }
                catch (NumberFormatException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
        return revisionNumber > 0 ? revisionNumber : -1;
    }

    public static String readFile(File file) throws IOException {
        return Files.toString((File)file, (Charset)Charsets.UTF_8);
    }

    public static boolean contains2Identifiers(String packageName) {
        return packageName.split("\\.").length >= 2;
    }

    public static boolean directoriesContainSameContent(File dir1, File dir2, FileFilter filter) throws IOException {
        if (dir1.exists() != dir2.exists()) {
            return false;
        }
        File[] children1 = AndroidCommonUtils.getFilteredChildren(dir1, filter);
        File[] children2 = AndroidCommonUtils.getFilteredChildren(dir2, filter);
        if (children1 == null || children2 == null) {
            return children1 == children2;
        }
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            String content2;
            String content1;
            File child1 = children1[i];
            File child2 = children2[i];
            if (!Comparing.equal((String)child1.getName(), (String)child2.getName())) {
                return false;
            }
            boolean childDir = child1.isDirectory();
            if (childDir != child2.isDirectory()) {
                return false;
            }
            if (!(childDir ? !AndroidCommonUtils.directoriesContainSameContent(child1, child2, filter) : !Comparing.equal((String)(content1 = AndroidCommonUtils.readFile(child1)), (String)(content2 = AndroidCommonUtils.readFile(child2))))) continue;
            return false;
        }
        return true;
    }

    private static File[] getFilteredChildren(File dir, FileFilter filter) {
        File[] children = dir.listFiles();
        if (children == null || children.length == 0 || filter == null) {
            return children;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File child : children) {
            if (!child.isDirectory() && !filter.accept(child)) continue;
            result.add(child);
        }
        return result.toArray(new File[result.size()]);
    }

    public static String addSuffixToFileName(String path, String suffix) {
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            return path + suffix;
        }
        String a = path.substring(0, dot);
        String b = path.substring(dot);
        return a + suffix + b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void signApk(File srcApk, File destFile, PrivateKey privateKey, X509Certificate certificate) throws IOException, GeneralSecurityException {
        FileOutputStream fos = new FileOutputStream(destFile);
        SafeSignedJarBuilder builder = new SafeSignedJarBuilder(fos, privateKey, certificate, destFile.getPath());
        FileInputStream fis = new FileInputStream(srcApk);
        try {
            builder.writeZip(fis, null);
            builder.close();
        }
        finally {
            block24: {
                fis.close();
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
                break block24;
                catch (IOException ignored) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored2) {}
                    catch (Throwable throwable) {
                        try {
                            fos.close();
                        }
                        catch (IOException ignored3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        try {
            t.printStackTrace(writer);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    public static boolean hasXmxParam(List<String> parameters) {
        for (String param : parameters) {
            if (!param.startsWith("-Xmx")) continue;
            return true;
        }
        return false;
    }

    public static String executeZipAlign(String zipAlignPath, File source, File destination) {
        BaseOSProcessHandler handler;
        ProcessBuilder processBuilder = new ProcessBuilder(zipAlignPath, "-f", "4", source.getAbsolutePath(), destination.getAbsolutePath());
        try {
            handler = new BaseOSProcessHandler(processBuilder.start(), "", null);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        final StringBuilder builder = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                builder.append(event.getText());
            }
        });
        handler.startNotify();
        handler.waitFor();
        int exitCode = handler.getProcess().exitValue();
        return exitCode != 0 ? builder.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<AndroidCompilerMessageKind, List<String>> buildArtifact(String artifactName, String messagePrefix, String sdkLocation, IAndroidTarget target, String artifactFilePath, String keyStorePath, String keyAlias, String keyStorePassword, String keyPassword) throws GeneralSecurityException, IOException {
        HashMap messages = new HashMap();
        messages.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        messages.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        Pair<PrivateKey, X509Certificate> pair = AndroidCommonUtils.getPrivateKeyAndCertificate(messagePrefix, (Map<AndroidCompilerMessageKind, List<String>>)messages, keyAlias, keyStorePath, keyStorePassword, keyPassword);
        if (pair == null) {
            return messages;
        }
        String prefix = "Cannot sign artifact " + artifactName + ": ";
        if (artifactFilePath == null) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add(prefix + "output path is not specified");
            return messages;
        }
        File artifactFile = new File(artifactFilePath);
        if (!artifactFile.exists()) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add(prefix + "file " + artifactFilePath + " hasn't been generated");
            return messages;
        }
        String zipAlignPath = AndroidCommonUtils.getZipAlign(sdkLocation, target);
        boolean runZipAlign = new File(zipAlignPath).isFile();
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDirectory((String)"android_artifact", (String)"tmp");
            File tmpArtifact = new File(tmpDir, "tmpArtifact.apk");
            AndroidCommonUtils.signApk(artifactFile, tmpArtifact, (PrivateKey)pair.getFirst(), (X509Certificate)pair.getSecond());
            if (!FileUtil.delete((File)artifactFile)) {
                ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Cannot delete file " + artifactFile.getPath());
                HashMap hashMap = messages;
                return hashMap;
            }
            if (runZipAlign) {
                String errorMessage = AndroidCommonUtils.executeZipAlign(zipAlignPath, tmpArtifact, artifactFile);
                if (errorMessage != null) {
                    ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add(messagePrefix + "zip-align: " + errorMessage);
                    HashMap hashMap = messages;
                    return hashMap;
                }
            } else {
                ((List)messages.get((Object)AndroidCompilerMessageKind.WARNING)).add(messagePrefix + AndroidCommonBundle.message("android.artifact.building.cannot.find.zip.align.error", new Object[0]));
                FileUtil.copy((File)tmpArtifact, (File)artifactFile);
            }
        }
        finally {
            if (tmpDir != null) {
                FileUtil.delete((File)tmpDir);
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<PrivateKey, X509Certificate> getPrivateKeyAndCertificate(String errorPrefix, Map<AndroidCompilerMessageKind, List<String>> messages, String keyAlias, String keyStoreFilePath, String keyStorePasswordStr, String keyPasswordStr) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (keyStoreFilePath == null || keyStoreFilePath.length() == 0) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key store file is not specified");
            return null;
        }
        if (keyStorePasswordStr == null) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key store password is not specified");
            return null;
        }
        if (keyAlias == null || keyAlias.length() == 0) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key alias is not specified");
            return null;
        }
        if (keyPasswordStr == null) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key password is not specified");
            return null;
        }
        File keyStoreFile = new File(keyStoreFilePath);
        char[] keystorePassword = keyStorePasswordStr.toCharArray();
        char[] plainKeyPassword = keyPasswordStr.toCharArray();
        FileInputStream is = null;
        try {
            is = new FileInputStream(keyStoreFile);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, keystorePassword);
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(plainKeyPassword));
            if (entry == null) {
                messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + AndroidCommonBundle.message("android.artifact.building.cannot.find.key.error", keyAlias));
                Pair<PrivateKey, X509Certificate> pair = null;
                return pair;
            }
            PrivateKey privateKey = entry.getPrivateKey();
            Certificate certificate = entry.getCertificate();
            if (privateKey == null || certificate == null) {
                messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + AndroidCommonBundle.message("android.artifact.building.cannot.find.key.error", keyAlias));
                Pair<PrivateKey, X509Certificate> pair = null;
                return pair;
            }
            Pair pair = Pair.create((Object)privateKey, (Object)((X509Certificate)certificate));
            return pair;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    public static String getZipAlign(String sdkPath, IAndroidTarget target) {
        BuildToolInfo buildToolInfo = target.getBuildToolInfo();
        if (buildToolInfo != null) {
            String path = null;
            try {
                path = buildToolInfo.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            if (path != null && new File(path).exists()) {
                return path;
            }
        }
        return sdkPath + File.separatorChar + AndroidCommonUtils.toolPath(SdkConstants.FN_ZIPALIGN);
    }
}

