/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidOSProcessHandler;

public final class AndroidExecutionUtil {
    private AndroidExecutionUtil() {
    }

    public static Map<AndroidCompilerMessageKind, List<String>> doExecute(String ... argv) throws IOException {
        return AndroidExecutionUtil.doExecute(argv, Collections.emptyMap());
    }

    public static Map<AndroidCompilerMessageKind, List<String>> doExecute(String[] argv, Map<? extends String, ? extends String> enviroment) throws IOException {
        Process process;
        AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
        if (testingManager != null) {
            process = testingManager.getCommandExecutor().createProcess(argv, enviroment);
        } else {
            ProcessBuilder builder = new ProcessBuilder(argv);
            builder.environment().putAll(enviroment);
            process = builder.start();
        }
        ProcessResult result = AndroidExecutionUtil.readProcessOutput(process);
        Map<AndroidCompilerMessageKind, List<String>> messages = result.getMessages();
        int code = result.getExitCode();
        List<String> errMessages = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        if (code != 0 && errMessages.isEmpty()) {
            throw new IOException("Command \"" + AndroidExecutionUtil.concat(argv) + "\" execution failed with exit code " + code);
        }
        if (code == 0) {
            messages.get((Object)AndroidCompilerMessageKind.WARNING).addAll(errMessages);
            errMessages.clear();
        }
        return messages;
    }

    private static String concat(String ... strs) {
        StringBuilder builder = new StringBuilder();
        int n = strs.length;
        for (int i = 0; i < n; ++i) {
            builder.append(strs[i]);
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    private static ProcessResult readProcessOutput(Process process) throws IOException {
        AndroidOSProcessHandler handler = new AndroidOSProcessHandler(process, "");
        handler.startNotify();
        handler.waitFor();
        int exitCode = handler.getProcess().exitValue();
        return new ProcessResult(handler.getInfoMessages(), handler.getErrorMessages(), exitCode);
    }

    public static <T> void addMessages(Map<T, List<String>> messages, Map<T, List<String>> toAdd) {
        for (Map.Entry<T, List<String>> entry : toAdd.entrySet()) {
            List<String> list = messages.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<String>();
                messages.put(entry.getKey(), list);
            }
            list.addAll((Collection<String>)entry.getValue());
        }
    }

    private static final class ProcessResult {
        private final int myExitCode;
        private final Map<AndroidCompilerMessageKind, List<String>> myMessages;

        public ProcessResult(List<String> information, List<String> error, int exitCode) {
            this.myExitCode = exitCode;
            this.myMessages = new HashMap<AndroidCompilerMessageKind, List<String>>(2);
            this.myMessages.put(AndroidCompilerMessageKind.INFORMATION, information);
            this.myMessages.put(AndroidCompilerMessageKind.ERROR, error);
            this.myMessages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        }

        public Map<AndroidCompilerMessageKind, List<String>> getMessages() {
            return this.myMessages;
        }

        public int getExitCode() {
            return this.myExitCode;
        }
    }
}

