/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmComponentExtension;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJarBinarySpec;
import org.gradle.jvm.internal.DefaultJvmLibrarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JavaPlatformResolver;
import org.gradle.jvm.internal.JvmLibrarySpecInternal;
import org.gradle.jvm.internal.plugins.DefaultJvmComponentExtension;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolChainRegistry;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.platform.base.internal.toolchain.ToolResolver;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmComponentPlugin
extends RuleSource {
    @ComponentType
    void register(ComponentTypeBuilder<JvmLibrarySpec> builder) {
        builder.defaultImplementation(DefaultJvmLibrarySpec.class);
    }

    @BinaryType
    void registerJar(BinaryTypeBuilder<JarBinarySpec> builder) {
        builder.defaultImplementation(DefaultJarBinarySpec.class);
    }

    @Model
    JvmComponentExtension jvm(ServiceRegistry serviceRegistry) {
        Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
        return (JvmComponentExtension)instantiator.newInstance(DefaultJvmComponentExtension.class, new Object[0]);
    }

    @Model
    BinaryNamingSchemeBuilder binaryNamingSchemeBuilder() {
        return new DefaultBinaryNamingSchemeBuilder();
    }

    @Model
    JavaToolChainRegistry javaToolChain(ServiceRegistry serviceRegistry) {
        JavaToolChainInternal toolChain = (JavaToolChainInternal)serviceRegistry.get(JavaToolChainInternal.class);
        return new DefaultJavaToolChainRegistry(toolChain);
    }

    @Mutate
    public void registerPlatformResolver(PlatformResolvers platformResolvers) {
        platformResolvers.register((PlatformResolver)new JavaPlatformResolver());
    }

    @ComponentBinaries
    public void createBinaries(CollectionBuilder<JarBinarySpec> binaries, JvmLibrarySpec jvmLibrary, PlatformResolvers platforms, BinaryNamingSchemeBuilder namingSchemeBuilder, JvmComponentExtension jvmComponentExtension, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry, JavaToolChainRegistry toolChains) {
        File binariesDir = new File(buildDir, "jars");
        File classesDir = new File(buildDir, "classes");
        ToolResolver toolResolver = (ToolResolver)serviceRegistry.get(ToolResolver.class);
        List<JavaPlatform> selectedPlatforms = this.resolvePlatforms(jvmLibrary, platforms);
        for (JavaPlatform platform : selectedPlatforms) {
            JavaToolChainInternal toolChain = (JavaToolChainInternal)toolChains.getForPlatform(platform);
            String binaryName = this.createBinaryName(jvmLibrary, namingSchemeBuilder, selectedPlatforms, platform);
            binaries.create(binaryName, (Action)new ConfigureJarBinary(jvmLibrary, toolChain, platform, classesDir, binariesDir, jvmComponentExtension, toolResolver));
        }
    }

    private List<JavaPlatform> resolvePlatforms(JvmLibrarySpec jvmLibrary, final PlatformResolvers platforms) {
        List<PlatformRequirement> targetPlatforms = ((JvmLibrarySpecInternal)jvmLibrary).getTargetPlatforms();
        if (targetPlatforms.isEmpty()) {
            String defaultJavaPlatformName = new DefaultJavaPlatform(JavaVersion.current()).getName();
            targetPlatforms = Collections.singletonList(DefaultPlatformRequirement.create((String)defaultJavaPlatformName));
        }
        return CollectionUtils.collect((List)targetPlatforms, (Transformer)new Transformer<JavaPlatform, PlatformRequirement>(){

            public JavaPlatform transform(PlatformRequirement platformRequirement) {
                return (JavaPlatform)platforms.resolve(JavaPlatform.class, platformRequirement);
            }
        });
    }

    @BinaryTasks
    public void createTasks(CollectionBuilder<Task> tasks, final JarBinarySpec binary) {
        String taskName = "create" + StringUtils.capitalize((String)binary.getName());
        tasks.create(taskName, Jar.class, (Action)new Action<Jar>(){

            public void execute(Jar jar) {
                jar.setDescription(String.format("Creates the binary file for %s.", binary));
                jar.from(new Object[]{binary.getClassesDir()});
                jar.from(new Object[]{binary.getResourcesDir()});
                jar.setDestinationDir(binary.getJarFile().getParentFile());
                jar.setArchiveName(binary.getJarFile().getName());
            }
        });
        binary.builtBy(new Object[]{tasks.get(taskName)});
    }

    private String createBinaryName(JvmLibrarySpec jvmLibrary, BinaryNamingSchemeBuilder namingSchemeBuilder, List<JavaPlatform> selectedPlatforms, JavaPlatform platform) {
        BinaryNamingSchemeBuilder componentBuilder = namingSchemeBuilder.withComponentName(jvmLibrary.getName()).withTypeString("jar");
        if (selectedPlatforms.size() > 1) {
            componentBuilder = componentBuilder.withVariantDimension(platform.getName());
        }
        return componentBuilder.build().getLifecycleTaskName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigureJarBinary
    implements Action<JarBinarySpec> {
        private final JvmLibrarySpec jvmLibrary;
        private final JavaToolChainInternal toolChain;
        private final JavaPlatform platform;
        private final File classesDir;
        private final File binariesDir;
        private final JvmComponentExtension jvmComponentExtension;
        private final ToolResolver toolResolver;

        public ConfigureJarBinary(JvmLibrarySpec jvmLibrary, JavaToolChainInternal toolChain, JavaPlatform platform, File classesDir, File binariesDir, JvmComponentExtension jvmComponentExtension, ToolResolver toolResolver) {
            this.jvmLibrary = jvmLibrary;
            this.toolChain = toolChain;
            this.platform = platform;
            this.classesDir = classesDir;
            this.binariesDir = binariesDir;
            this.jvmComponentExtension = jvmComponentExtension;
            this.toolResolver = toolResolver;
        }

        public void execute(JarBinarySpec jarBinary) {
            JarBinarySpecInternal jarBinaryInternal = (JarBinarySpecInternal)jarBinary;
            jarBinaryInternal.setBaseName(this.jvmLibrary.getName());
            jarBinary.setToolChain(this.toolChain);
            jarBinary.setTargetPlatform(this.platform);
            jarBinary.setToolResolver(this.toolResolver);
            File outputDir = new File(this.classesDir, jarBinary.getName());
            jarBinary.setClassesDir(outputDir);
            jarBinary.setResourcesDir(outputDir);
            jarBinary.setJarFile(new File(this.binariesDir, String.format("%s/%s.jar", jarBinary.getName(), jarBinaryInternal.getBaseName())));
            this.jvmComponentExtension.getAllBinariesAction().execute((Object)jarBinary);
        }
    }
}

