/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.google.common.base.Joiner;
import com.pty4j.PtyException;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.windows.WinPTYInputStream;
import com.pty4j.windows.WinPTYOutputStream;
import com.pty4j.windows.WinPty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WinPtyProcess
extends PtyProcess {
    private final WinPty myWinPty;
    private final WinPTYInputStream myInputStream;
    private final InputStream myErrorStream;
    private final WinPTYOutputStream myOutputStream;

    @Deprecated
    public WinPtyProcess(String[] command, String[] environment, String workingDirectory, boolean consoleMode) throws IOException {
        this(command, WinPtyProcess.convertEnvironment(environment), workingDirectory, consoleMode);
    }

    private static String convertEnvironment(String[] environment) {
        StringBuilder envString = new StringBuilder();
        for (String s : environment) {
            envString.append(s).append('\u0000');
        }
        envString.append('\u0000');
        return envString.toString();
    }

    public WinPtyProcess(String[] command, String environment, String workingDirectory, boolean consoleMode) throws IOException {
        try {
            this.myWinPty = new WinPty(Joiner.on((String)" ").join((Object[])command), workingDirectory, environment, consoleMode);
        }
        catch (PtyException e) {
            throw new IOException("Couldn't create PTY", e);
        }
        this.myInputStream = new WinPTYInputStream(this.myWinPty.getInputPipe());
        this.myOutputStream = new WinPTYOutputStream(this.myWinPty.getOutputPipe(), consoleMode, true);
        this.myErrorStream = !consoleMode ? new InputStream(){

            public int read() {
                return -1;
            }
        } : new WinPTYInputStream(this.myWinPty.getErrorPipe());
    }

    public boolean isRunning() {
        return this.myWinPty.exitValue() == -1;
    }

    public void setWinSize(WinSize winSize) {
        this.myWinPty.setWinSize(winSize);
    }

    public WinSize getWinSize() throws IOException {
        return null;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public InputStream getInputStream() {
        return this.myInputStream;
    }

    public InputStream getErrorStream() {
        return this.myErrorStream;
    }

    public int waitFor() throws InterruptedException {
        int exitCode;
        while ((exitCode = this.myWinPty.exitValue()) == -1) {
            Thread.sleep(1000L);
        }
        return exitCode;
    }

    public int exitValue() {
        int exitValue = this.myWinPty.exitValue();
        if (exitValue == -1) {
            throw new IllegalThreadStateException("Not terminated yet");
        }
        return exitValue;
    }

    public void destroy() {
        this.myWinPty.close();
    }
}

