/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Set;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNURL;

public class NestedCopiesBuilder
implements StatusReceiver {
    private final Set<NestedCopyInfo> myCopies;
    private final SvnFileUrlMapping myMapping;
    private final SvnVcs myVcs;

    public NestedCopiesBuilder(SvnVcs vcs, SvnFileUrlMapping mapping) {
        this.myVcs = vcs;
        this.myMapping = mapping;
        this.myCopies = ContainerUtil.newHashSet();
    }

    @Override
    public void process(FilePath path, Status status) {
        VirtualFile file = path.getVirtualFile();
        if (file != null) {
            if (status.is(StatusType.STATUS_EXTERNAL)) {
                this.myCopies.add(new NestedCopyInfo(file, null, WorkingCopyFormat.UNKNOWN, NestedCopyType.external, null));
            } else if (status.getURL() != null && !status.is(StatusType.STATUS_UNVERSIONED) && status.isSwitched()) {
                this.myCopies.add(new NestedCopyInfo(file, status.getURL(), this.myVcs.getWorkingCopyFormat(path.getIOFile()), NestedCopyType.switched, status.getRepositoryRootURL()));
            }
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
    }

    @Override
    public void processCopyRoot(VirtualFile file, SVNURL url, WorkingCopyFormat format, SVNURL rootURL) {
        this.myCopies.add(new NestedCopyInfo(file, url, format, NestedCopyType.inner, rootURL));
    }

    @Override
    public void bewareRoot(VirtualFile vf, SVNURL url) {
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
        RootUrlInfo info = this.myMapping.getWcRootForFilePath(ioFile);
        if (info != null && FileUtil.filesEqual((File)ioFile, (File)info.getIoFile()) && !info.getAbsoluteUrlAsUrl().equals((Object)url)) {
            this.myVcs.invokeRefreshSvnRoots();
        }
    }

    @Override
    public void finish() {
    }

    public Set<NestedCopyInfo> getCopies() {
        return this.myCopies;
    }
}

