/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class Node {
    private final VirtualFile myFile;
    private final SVNURL myUrl;
    private final SVNURL myRepositoryUrl;
    private final SvnBindException myError;

    public Node(VirtualFile file, SVNURL url, SVNURL repositoryUrl) {
        this(file, url, repositoryUrl, null);
    }

    public Node(VirtualFile file, SVNURL url, SVNURL repositoryUrl, SvnBindException error) {
        this.myFile = file;
        this.myUrl = url;
        this.myRepositoryUrl = repositoryUrl;
        this.myError = error;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public File getIoFile() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile());
    }

    public SVNURL getUrl() {
        return this.myUrl;
    }

    public SVNURL getRepositoryRootUrl() {
        return this.myRepositoryUrl;
    }

    public SvnBindException getError() {
        return this.myError;
    }

    public boolean hasError() {
        return this.myError != null;
    }

    public boolean onUrl(SVNURL url) {
        return this.myUrl.equals((Object)url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (this.myError != null ? node.myError == null || !this.myError.getMessage().equals(node.myError.getMessage()) : node.myError != null) {
            return false;
        }
        if (!this.myFile.equals(node.myFile)) {
            return false;
        }
        if (!this.myRepositoryUrl.equals((Object)node.myRepositoryUrl)) {
            return false;
        }
        return this.myUrl.equals((Object)node.myUrl);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myRepositoryUrl.hashCode();
        result = 31 * result + (this.myError != null ? this.myError.getMessage().hashCode() : 0);
        return result;
    }
}

