/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.NestedCopiesBuilder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangeProviderContext;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnRecursiveStatusWalker;
import org.jetbrains.idea.svn.SvnScopeZipper;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;

public class SvnChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangeProvider");
    public static final String ourDefaultListName = VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]);
    public static final String PROPERTY_LAYER = "Property";
    private static final NotNullFactory<Map<String, File>> NAME_TO_FILE_MAP_FACTORY = new NotNullFactory<Map<String, File>>(){

        public Map<String, File> create() {
            return ContainerUtil.newHashMap();
        }
    };
    private final SvnVcs myVcs;
    private final VcsContextFactory myFactory;
    private final SvnFileUrlMappingImpl mySvnFileUrlMapping;

    public SvnChangeProvider(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myFactory = VcsContextFactory.SERVICE.getInstance();
        this.mySvnFileUrlMapping = (SvnFileUrlMappingImpl)vcs.getSvnFileUrlMapping();
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        SvnScopeZipper zipper = new SvnScopeZipper(dirtyScope);
        zipper.run();
        Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap = zipper.getNonRecursiveDirs();
        ISVNStatusFileProvider fileProvider = SvnChangeProvider.createFileProvider(nonRecursiveMap);
        try {
            SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, progress);
            NestedCopiesBuilder nestedCopiesBuilder = new NestedCopiesBuilder(this.myVcs, this.mySvnFileUrlMapping);
            EventDispatcher statusReceiver = EventDispatcher.create(StatusReceiver.class);
            statusReceiver.addListener((EventListener)context);
            statusReceiver.addListener((EventListener)nestedCopiesBuilder);
            SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, (StatusReceiver)statusReceiver.getMulticaster(), progress);
            for (FilePath path : zipper.getRecursiveDirs()) {
                walker.go(path, Depth.INFINITY);
            }
            walker.setFileProvider(fileProvider);
            for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
                walker.go(item.getDir(), Depth.IMMEDIATES);
            }
            ((StatusReceiver)statusReceiver.getMulticaster()).finish();
            this.processCopiedAndDeleted(context, dirtyScope);
            SvnChangeProvider.processUnsaved(dirtyScope, addGate, context);
            Set<NestedCopyInfo> nestedCopies = nestedCopiesBuilder.getCopies();
            this.mySvnFileUrlMapping.acceptNestedData(nestedCopies);
            SvnChangeProvider.putAdministrative17UnderVfsListener(nestedCopies);
        }
        catch (SvnExceptionWrapper e) {
            LOG.info((Throwable)e);
            throw new VcsException(e.getCause());
        }
        catch (SVNException e) {
            if (e.getCause() != null) {
                throw new VcsException(e.getMessage() + " " + e.getCause().getMessage(), (Throwable)e);
            }
            throw new VcsException((Throwable)e);
        }
    }

    private static void putAdministrative17UnderVfsListener(Set<NestedCopyInfo> pointInfos) {
        if (!SvnVcs.ourListenToWcDb) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (NestedCopyInfo info : pointInfos) {
            if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat()) || NestedCopyType.switched.equals((Object)info.getType())) continue;
            VirtualFile root = info.getFile();
            lfs.refreshIoFiles(Collections.singletonList(SvnUtil.getWcDb(new File(root.getPath()))), true, false, null);
        }
    }

    private static void processUnsaved(VcsDirtyScope dirtyScope, ChangeListManagerGate addGate, SvnChangeProviderContext context) throws SVNException {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : fileDocumentManager.getUnsavedDocuments()) {
            FileStatus status;
            VirtualFile file = fileDocumentManager.getFile(unsavedDocument);
            if (file == null || !dirtyScope.belongsTo((FilePath)new FilePathImpl(file)) || !fileDocumentManager.isFileModified(file) || (status = addGate.getStatus(file)) != null && !FileStatus.NOT_CHANGED.equals(status)) continue;
            context.addModifiedNotSavedChange(file);
        }
    }

    private static ISVNStatusFileProvider createFileProvider(Map<String, SvnScopeZipper.MyDirNonRecursive> nonRecursiveMap) {
        final HashMap result = ContainerUtil.newHashMap();
        for (SvnScopeZipper.MyDirNonRecursive item : nonRecursiveMap.values()) {
            File file = item.getDir().getIOFile();
            Map fileMap = (Map)ContainerUtil.getOrCreate((Map)result, (Object)file.getAbsolutePath(), NAME_TO_FILE_MAP_FACTORY);
            for (FilePath path : item.getChildrenList()) {
                fileMap.put(path.getName(), path.getIOFile());
            }
            if (file.getParentFile() == null) continue;
            Map parentMap = (Map)ContainerUtil.getOrCreate((Map)result, (Object)file.getParentFile().getAbsolutePath(), NAME_TO_FILE_MAP_FACTORY);
            parentMap.put(file.getName(), file);
        }
        return new ISVNStatusFileProvider(){

            public Map<String, File> getChildrenFiles(File parent) {
                return (Map)result.get(parent.getAbsolutePath());
            }
        };
    }

    private void processCopiedAndDeleted(SvnChangeProviderContext context, VcsDirtyScope dirtyScope) throws SVNException {
        for (SvnChangedFile copiedFile : context.getCopiedFiles()) {
            context.checkCanceled();
            this.processCopiedFile(copiedFile, context, dirtyScope);
        }
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            context.checkCanceled();
            context.processStatus(deletedFile.getFilePath(), deletedFile.getStatus());
        }
    }

    public void getChanges(FilePath path, boolean recursive, ChangelistBuilder builder) throws SVNException, SvnBindException {
        SvnChangeProviderContext context = new SvnChangeProviderContext(this.myVcs, builder, null);
        SvnRecursiveStatusWalker walker = new SvnRecursiveStatusWalker(this.myVcs, context, ProgressManager.getInstance().getProgressIndicator());
        walker.go(path, recursive ? Depth.INFINITY : Depth.IMMEDIATES);
        this.processCopiedAndDeleted(context, null);
    }

    private void processCopiedFile(SvnChangedFile copiedFile, SvnChangeProviderContext context, VcsDirtyScope dirtyScope) throws SVNException {
        boolean foundRename = false;
        Status copiedStatus = copiedFile.getStatus();
        String copyFromURL = copiedFile.getCopyFromURL();
        HashSet<SvnChangedFile> deletedToDelete = new HashSet<SvnChangedFile>();
        for (SvnChangedFile deletedFile : context.getDeletedFiles()) {
            Status deletedStatus = deletedFile.getStatus();
            if (deletedStatus.getURL() == null || !Comparing.equal((String)copyFromURL, (String)deletedStatus.getURL().toString())) continue;
            String clName = SvnUtil.getChangelistName(copiedFile.getStatus());
            this.applyMovedChange(context, copiedFile.getFilePath(), dirtyScope, deletedToDelete, deletedFile, copiedStatus, clName);
            for (SvnChangedFile deletedChild : context.getDeletedFiles()) {
                Status childStatus = deletedChild.getStatus();
                SVNURL childUrl = childStatus.getURL();
                if (childUrl == null) continue;
                String childURL = childUrl.toDecodedString();
                if (!StringUtil.startsWithConcatenation((String)childURL, (String[])new String[]{copyFromURL, "/"})) continue;
                String relativePath = childURL.substring(copyFromURL.length());
                File newPath = new File(copiedFile.getFilePath().getIOFile(), relativePath);
                FilePath newFilePath = this.myFactory.createFilePathOn(newPath);
                if (context.isDeleted(newFilePath)) continue;
                this.applyMovedChange(context, newFilePath, dirtyScope, deletedToDelete, deletedChild, context.getTreeConflictStatus(newPath), clName);
            }
            foundRename = true;
            break;
        }
        List<SvnChangedFile> deletedFiles = context.getDeletedFiles();
        for (SvnChangedFile file : deletedToDelete) {
            deletedFiles.remove(file);
        }
        if (!foundRename && copiedStatus.getURL() != null) {
            Status status;
            File wcPath = SvnChangeProvider.guessWorkingCopyPath(copiedStatus.getFile(), copiedStatus.getURL(), copyFromURL);
            try {
                status = this.myVcs.getFactory(wcPath).createStatusClient().doStatus(wcPath, false);
            }
            catch (SvnBindException ex) {
                LOG.info((Throwable)((Object)ex));
                status = null;
            }
            if (status != null && status.is(StatusType.STATUS_DELETED)) {
                FilePath filePath = this.myFactory.createFilePathOnDeleted(wcPath, false);
                SvnContentRevision beforeRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, status.getRevision());
                ContentRevision afterRevision = CurrentContentRevision.create((FilePath)copiedFile.getFilePath());
                context.getBuilder().processChangeInList(context.createMovedChange(beforeRevision, afterRevision, copiedStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                foundRename = true;
            }
        }
        if (!foundRename) {
            LOG.info("Rename not found for " + copiedFile.getFilePath().getPresentableUrl());
            context.processStatus(copiedFile.getFilePath(), copiedStatus);
        }
    }

    private void applyMovedChange(SvnChangeProviderContext context, FilePath oldPath, final VcsDirtyScope dirtyScope, Set<SvnChangedFile> deletedToDelete, SvnChangedFile deletedFile, Status copiedStatus, String clName) throws SVNException {
        boolean isUnder;
        final Change change = context.createMovedChange(this.createBeforeRevision(deletedFile, true), CurrentContentRevision.create((FilePath)oldPath), copiedStatus, deletedFile.getStatus());
        boolean bl = isUnder = dirtyScope == null ? true : (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ChangeListManagerImpl.isUnder((Change)change, (VcsDirtyScope)dirtyScope);
            }
        });
        if (isUnder) {
            context.getBuilder().removeRegisteredChangeFor(oldPath);
            context.getBuilder().processChangeInList(change, clName, SvnVcs.getKey());
            deletedToDelete.add(deletedFile);
        }
    }

    private SvnContentRevision createBeforeRevision(SvnChangedFile changedFile, boolean forDeleted) {
        Status status = changedFile.getStatus();
        FilePath path = changedFile.getFilePath();
        return SvnContentRevision.createBaseRevision(this.myVcs, (FilePath)(forDeleted ? FilePathImpl.createForDeletedFile((File)status.getFile(), (boolean)path.isDirectory()) : path), status.getRevision());
    }

    private static File guessWorkingCopyPath(File file, SVNURL url, String copyFromURL) throws SVNException {
        int i;
        String copiedPath = url.getPath();
        String copyFromPath = SVNURL.parseURIEncoded((String)copyFromURL).getPath();
        String commonPathAncestor = SVNPathUtil.getCommonPathAncestor((String)copiedPath, (String)copyFromPath);
        int pathSegmentCount = SVNPathUtil.getSegmentsCount((String)copiedPath);
        int ancestorSegmentCount = SVNPathUtil.getSegmentsCount((String)commonPathAncestor);
        boolean startsWithSlash = file.getAbsolutePath().startsWith("/");
        List segments = StringUtil.split((String)file.getPath(), (String)File.separator);
        List copyFromPathSegments = StringUtil.split((String)copyFromPath, (String)"/");
        ArrayList resultSegments = new ArrayList();
        int keepSegments = segments.size() - pathSegmentCount + ancestorSegmentCount;
        for (i = 0; i < keepSegments; ++i) {
            resultSegments.add(segments.get(i));
        }
        for (i = ancestorSegmentCount; i < copyFromPathSegments.size(); ++i) {
            resultSegments.add(copyFromPathSegments.get(i));
        }
        String result = StringUtil.join(resultSegments, (String)"/");
        return new File(startsWithSlash ? SvnUtil.ensureStartSlash(result) : result);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
        new CleanupWorker(VfsUtilCore.toVirtualFileArray(files), this.myVcs.getProject(), "action.Subversion.cleanup.progress.title").execute();
    }
}

