/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.net.URI;
import java.nio.channels.NonWritableChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SVNFileUtil.getAdminDirectoryName();
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String WC_DB_FILE_NAME = "wc.db";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    public static final int DEFAULT_PORT_INDICATOR = -1;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnUtil");
    public static final Pattern ERROR_PATTERN = Pattern.compile("^svn: (E(\\d+)): (.*)$", 8);
    public static final Pattern WARNING_PATTERN = Pattern.compile("^svn: warning: (W(\\d+)): (.*)$", 8);
    private static final Pair<SVNURL, WorkingCopyFormat> UNKNOWN_REPOSITORY_AND_FORMAT = Pair.create(null, (Object)((Object)WorkingCopyFormat.UNKNOWN));

    private SvnUtil() {
    }

    public static SVNErrorMessage parseWarning(String text) {
        Matcher matcher = WARNING_PATTERN.matcher(text);
        SVNErrorMessage error = null;
        if (matcher.find()) {
            error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.getErrorCode((int)Integer.parseInt(matcher.group(2))), (String)matcher.group(3), (int)1);
        }
        return error;
    }

    public static boolean isSvnVersioned(Project project, File parent) {
        return SvnUtil.isSvnVersioned(SvnVcs.getInstance(project), parent);
    }

    public static boolean isSvnVersioned(SvnVcs vcs, File parent) {
        Info info = vcs.getInfo(parent);
        return info != null;
    }

    public static Collection<VirtualFile> crawlWCRoots(Project project, File path, SvnWCRootCrawler callback, ProgressIndicator progress) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vf = lfs.findFileByIoFile(path);
        if (vf == null) {
            vf = lfs.refreshAndFindFileByIoFile(path);
        }
        if (vf == null) {
            return Collections.emptyList();
        }
        return SvnUtil.crawlWCRoots(project, vf, callback, progress);
    }

    private static Collection<VirtualFile> crawlWCRoots(Project project, VirtualFile vf, SvnWCRootCrawler callback, ProgressIndicator progress) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        boolean isDirectory = vf.isDirectory();
        VirtualFile parent = !isDirectory || !vf.exists() ? vf.getParent() : vf;
        File parentIo = new File(parent.getPath());
        if (SvnUtil.isSvnVersioned(project, parentIo)) {
            SvnUtil.checkCanceled(progress);
            File ioFile = new File(vf.getPath());
            callback.handleWorkingCopyRoot(ioFile, progress);
            SvnUtil.checkCanceled(progress);
            result.add(parent);
        } else if (isDirectory) {
            VirtualFile[] childrenVF;
            SvnUtil.checkCanceled(progress);
            for (VirtualFile file : childrenVF = parent.getChildren()) {
                SvnUtil.checkCanceled(progress);
                if (!file.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(project, file, callback, progress));
            }
        }
        return result;
    }

    private static void checkCanceled(ProgressIndicator progress) {
        if (progress != null && progress.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    public static String getExactLocation(SvnVcs vcs, File path) {
        Info info = vcs.getInfo(path);
        return info != null && info.getURL() != null ? info.getURL().toString() : null;
    }

    public static void doLockFiles(Project project, final SvnVcs activeVcs, final File[] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        if (activeVcs.getCheckoutOptions().getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles.length > 1);
            if (!dialog.showAndGet()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        final VcsException[] exception = new VcsException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.LOCK_FAILED) {
                    failedLocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                        }
                        activeVcs.getFactory(ioFile).createLockClient().lock(ioFile, force, lockMessage, eventHandler);
                    }
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            StringBuilder sb = new StringBuilder(SvnBundle.message("message.text.files.lock.failed", failedFiles.length == 1 ? 0 : 1));
            for (VcsException vcsException : exceptions) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(vcsException.getMessage());
            }
            throw new VcsException(sb.toString());
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static void doUnlockFiles(Project project, final SvnVcs activeVcs, final File[] ioFiles) throws VcsException {
        boolean force = true;
        final VcsException[] exception = new VcsException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.UNLOCK_FAILED) {
                    failedUnlocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                        }
                        activeVcs.getFactory(ioFile).createLockClient().unlock(ioFile, true, eventHandler);
                    }
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    public static Map<Pair<SVNURL, WorkingCopyFormat>, Set<Change>> splitChangesIntoWc(SvnVcs vcs, List<Change> changes) {
        return SvnUtil.splitIntoRepositoriesMap(vcs, changes, new Convertor<Change, FilePath>(){

            public FilePath convert(Change change) {
                return ChangesUtil.getFilePath((Change)change);
            }
        });
    }

    public static <T> Map<Pair<SVNURL, WorkingCopyFormat>, Set<T>> splitIntoRepositoriesMap(final SvnVcs vcs, List<T> items, final Convertor<T, FilePath> converter) {
        return ContainerUtil.classify(items.iterator(), (Convertor)new Convertor<T, Pair<SVNURL, WorkingCopyFormat>>(){

            public Pair<SVNURL, WorkingCopyFormat> convert(T item) {
                RootUrlInfo path = vcs.getSvnFileUrlMapping().getWcRootForFilePath(((FilePath)converter.convert(item)).getIOFile());
                return path == null ? UNKNOWN_REPOSITORY_AND_FORMAT : Pair.create((Object)path.getRepositoryUrlUrl(), (Object)((Object)path.getFormat()));
            }
        });
    }

    public static WorkingCopyFormat getFormat(File path) {
        WorkingCopyFormat result = null;
        File dbFile = SvnUtil.resolveDatabase(path);
        if (dbFile != null && (result = (WorkingCopyFormat)((Object)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new WorkingCopyFormatOperation(dbFile)))) == null) {
            SvnUtil.notifyDatabaseError();
        }
        return result != null ? result : WorkingCopyFormat.UNKNOWN;
    }

    private static void close(SqlJetDb db) {
        if (db != null) {
            try {
                db.close();
            }
            catch (SqlJetException e) {
                SvnUtil.notifyDatabaseError();
            }
        }
    }

    private static void notifyDatabaseError() {
        VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification("Some errors occurred while accessing svn working copy database.", NotificationType.ERROR).notify(null);
    }

    private static File resolveDatabase(File path) {
        File dbFile = SvnUtil.getWcDb(path);
        File result = null;
        try {
            if (dbFile.exists() && dbFile.isFile()) {
                result = dbFile;
            }
        }
        catch (SecurityException e) {
            LOG.error("Failed to access working copy database", (Throwable)e);
        }
        return result;
    }

    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryUUID() : null;
    }

    public static String getRepositoryUUID(SvnVcs vcs, SVNURL url) {
        try {
            Info info = vcs.getInfo(url, SVNRevision.UNDEFINED);
            return info == null ? null : info.getRepositoryUUID();
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    public static SVNURL getRepositoryRoot(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryRootURL() : null;
    }

    public static SVNURL getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SvnUtil.createUrl(url));
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    public static SVNURL getRepositoryRoot(SvnVcs vcs, SVNURL url) throws SvnBindException {
        Info info = vcs.getInfo(url, SVNRevision.HEAD);
        return info == null ? null : info.getRepositoryRootURL();
    }

    public static boolean isWorkingCopyRoot(File file) {
        return FileUtil.filesEqual((File)file, (File)SvnUtil.getWorkingCopyRootNew(file));
    }

    public static File getWorkingCopyRoot(File inFile) {
        File file;
        for (file = inFile; file != null && (file.isFile() || !file.exists()); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        File workingCopyRoot = null;
        try {
            workingCopyRoot = SVNWCUtil.getWorkingCopyRoot((File)file, (boolean)true);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (workingCopyRoot == null) {
            workingCopyRoot = SvnUtil.getWcCopyRootIf17(file, null);
        }
        return workingCopyRoot;
    }

    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return new File(baseDir, part);
    }

    public static VirtualFile getVirtualFile(String filePath) {
        final String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(path);
            }
        });
    }

    public static SVNURL getBranchForUrl(SvnVcs vcs, VirtualFile vcsRoot, String urlValue) {
        SVNURL url = null;
        try {
            url = SvnUtil.createUrl(urlValue);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return url != null ? SvnUtil.getBranchForUrl(vcs, vcsRoot, url) : null;
    }

    public static SVNURL getBranchForUrl(SvnVcs vcs, VirtualFile vcsRoot, SVNURL url) {
        SVNURL result = null;
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
        try {
            result = configuration.getWorkingBranch(url);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    public static boolean checkRepositoryVersion15(SvnVcs vcs, String url) {
        boolean result = false;
        try {
            result = vcs.getFactory().createRepositoryFeaturesClient().supportsMergeTracking(SvnUtil.createUrl(url));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    public static Status getStatus(SvnVcs vcs, File file) {
        try {
            return vcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    public static Depth getDepth(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null && info.getDepth() != null ? info.getDepth() : Depth.UNKNOWN;
    }

    public static boolean seemsLikeVersionedDir(VirtualFile file) {
        String adminName = SVNFileUtil.getAdminDirectoryName();
        VirtualFile child = file.findChild(adminName);
        return child != null && child.isDirectory();
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    public static SVNURL getUrl(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info == null ? null : info.getURL();
    }

    public static boolean remoteFolderIsEmpty(SvnVcs vcs, String url) throws VcsException {
        SvnTarget target = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(url));
        final Ref result = new Ref((Object)true);
        DirectoryEntryConsumer handler = new DirectoryEntryConsumer(){

            public void consume(DirectoryEntry entry) throws SVNException {
                if (entry != null) {
                    result.set((Object)false);
                }
            }
        };
        vcs.getFactory(target).createBrowseClient().list(target, null, Depth.IMMEDIATES, handler);
        return (Boolean)result.get();
    }

    public static File getWcDb(File file) {
        return new File(file, SVN_ADMIN_DIR_NAME + "/wc.db");
    }

    public static File getWcCopyRootIf17(File file, File upperBound) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return null;
        }
        while (current != null) {
            try {
                SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)current, (boolean)false);
                if (SvnWcGeneration.V17.equals((Object)svnWcGeneration)) {
                    return current;
                }
                if (SvnWcGeneration.V16.equals((Object)svnWcGeneration)) {
                    return null;
                }
                if (upperBound != null && FileUtil.filesEqual((File)upperBound, (File)current)) {
                    return null;
                }
                current = current.getParentFile();
            }
            catch (SVNException e) {
                return null;
            }
        }
        return null;
    }

    public static File getWorkingCopyRootNew(File file) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return SvnUtil.getWorkingCopyRoot(file);
        }
        WorkingCopyFormat format = SvnUtil.getFormat(current);
        return format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? current : SvnUtil.getWorkingCopyRoot(file);
    }

    private static File getParentWithDb(File file) {
        File current;
        boolean wcDbFound = false;
        for (current = file; current != null; current = current.getParentFile()) {
            File wcDb = SvnUtil.getWcDb(current);
            if (!wcDb.exists() || wcDb.isDirectory()) continue;
            wcDbFound = true;
            break;
        }
        if (!wcDbFound) {
            return null;
        }
        return current;
    }

    public static String getRelativeUrl(String parentUrl, String childUrl) {
        return FileUtilRt.getRelativePath((String)parentUrl, (String)childUrl, (char)'/', (boolean)true);
    }

    public static String getRelativePath(String parentPath, String childPath) {
        return FileUtilRt.getRelativePath((String)FileUtil.toSystemIndependentName((String)parentPath), (String)FileUtil.toSystemIndependentName((String)childPath), (char)'/');
    }

    public static String ensureStartSlash(String path) {
        return StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path : '/' + path;
    }

    public static String join(String ... parts) {
        return StringUtil.join((String[])parts, (String)"/");
    }

    public static String appendMultiParts(String base, String subPath) {
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        String result = base;
        for (String part : parts) {
            result = SVNPathUtil.append((String)result, (String)part);
        }
        return result;
    }

    public static SVNURL appendMultiParts(SVNURL base, String subPath) throws SVNException {
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        SVNURL result = base;
        for (String part : parts) {
            result = result.appendPath(part, false);
        }
        return result;
    }

    public static SVNURL removePathTail(SVNURL url) throws SvnBindException {
        return SvnUtil.createUrl(SVNPathUtil.removeTail((String)url.toDecodedString()));
    }

    public static SVNRevision getHeadRevision(SvnVcs vcs, SVNURL url) throws SvnBindException {
        Info info = vcs.getInfo(url, SVNRevision.HEAD);
        if (info == null) {
            throw new SvnBindException("Could not get info for " + url);
        }
        if (info.getRevision() == null) {
            throw new SvnBindException("Could not get revision for " + url);
        }
        return info.getRevision();
    }

    public static byte[] getFileContents(SvnVcs vcs, SvnTarget target, SVNRevision revision, SVNRevision pegRevision) throws VcsException {
        return vcs.getFactory(target).createContentClient().getContent(target, revision, pegRevision);
    }

    public static boolean hasDefaultPort(SVNURL result) {
        return !result.hasPort() || SVNURL.getDefaultPortNumber((String)result.getProtocol()) == result.getPort();
    }

    public static int resolvePort(SVNURL url) {
        return !SvnUtil.hasDefaultPort(url) ? url.getPort() : -1;
    }

    public static SVNURL createUrl(String url) throws SvnBindException {
        return SvnUtil.createUrl(url, true);
    }

    public static SVNURL createUrl(String url, boolean encoded) throws SvnBindException {
        try {
            SVNURL result;
            SVNURL sVNURL = result = encoded ? SVNURL.parseURIEncoded((String)url) : SVNURL.parseURIDecoded((String)url);
            if (result.hasPort() && SvnUtil.hasDefaultPort(result)) {
                result = SVNURL.create((String)result.getProtocol(), (String)result.getUserInfo(), (String)result.getHost(), (int)-1, (String)result.getURIEncodedPath(), (boolean)true);
            }
            return result;
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    public static SVNURL parseUrl(String url) {
        try {
            return SVNURL.parseURIEncoded((String)url);
        }
        catch (SVNException e) {
            throw SvnUtil.createIllegalArgument(e);
        }
    }

    public static SVNURL append(SVNURL parent, String child) {
        try {
            return parent.appendPath(child, false);
        }
        catch (SVNException e) {
            throw SvnUtil.createIllegalArgument(e);
        }
    }

    public static IllegalArgumentException createIllegalArgument(SVNException e) {
        IllegalArgumentException runtimeException = new IllegalArgumentException();
        runtimeException.initCause(e);
        return runtimeException;
    }

    public static String getChangelistName(Status status) {
        return status.getKind().isFile() ? status.getChangelistName() : null;
    }

    public static boolean isUnversionedOrNotFound(SvnBindException e) {
        return e.contains(SVNErrorCode.WC_PATH_NOT_FOUND) || e.contains(SVNErrorCode.UNVERSIONED_RESOURCE) || e.contains(SVNErrorCode.WC_NOT_WORKING_COPY) || e.contains(SVNErrorCode.ILLEGAL_TARGET) || StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"(not a versioned resource)");
    }

    public static SvnTarget append(SvnTarget target, String path) throws SvnBindException {
        return SvnUtil.append(target, path, false);
    }

    public static SvnTarget append(SvnTarget target, String path, boolean checkAbsolute) throws SvnBindException {
        SvnTarget result;
        if (target.isFile()) {
            result = SvnTarget.fromFile((File)SvnUtil.resolvePath(target.getFile(), path));
        } else {
            try {
                result = SvnTarget.fromURL((SVNURL)(checkAbsolute && URI.create(path).isAbsolute() ? SVNURL.parseURIEncoded((String)path) : target.getURL().appendPath(path, false)));
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
        }
        return result;
    }

    public static File resolvePath(File base, String path) {
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = ".".equals(path) ? base : new File(base, path);
        }
        return result;
    }

    public static String toDecodedString(SvnTarget target) {
        return target.isFile() ? target.getFile().getPath() : target.getURL().toDecodedString();
    }

    private static class WorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        private final File myDbFile;

        public WorkingCopyFormatOperation(File dbFile) {
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public WorkingCopyFormat execute(boolean lastAttempt) {
            SqlJetDb db = null;
            WorkingCopyFormat result = null;
            try {
                db = SqlJetDb.open((File)this.myDbFile, (boolean)true);
                result = WorkingCopyFormat.getInstance(db.getOptions().getUserVersion());
            }
            catch (NonWritableChannelException e) {
                LOG.info((Throwable)e);
                SvnUtil.close(db);
            }
            catch (SqlJetException e2) {
                LOG.info((Throwable)e2);
                {
                    catch (Throwable throwable) {
                        SvnUtil.close(db);
                        throw throwable;
                    }
                }
                SvnUtil.close(db);
            }
            SvnUtil.close(db);
            return result;
        }
    }
}

