/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;

public class MarkLocallyDeletedTreeConflictResolvedAction
extends AnAction {
    public MarkLocallyDeletedTreeConflictResolvedAction() {
        super(SvnBundle.message("action.mark.tree.conflict.resolved.text", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        final MyLocallyDeletedChecker locallyDeletedChecker = new MyLocallyDeletedChecker(e);
        if (!locallyDeletedChecker.isEnabled()) {
            return;
        }
        String markText = SvnBundle.message("action.mark.tree.conflict.resolved.confirmation.title", new Object[0]);
        Project project = locallyDeletedChecker.getProject();
        int result = Messages.showYesNoDialog((Project)project, (String)SvnBundle.message("action.mark.tree.conflict.resolved.confirmation.text", new Object[0]), (String)markText, (Icon)Messages.getQuestionIcon());
        if (result == 0) {
            final Ref exception = new Ref();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, markText, true, BackgroundFromStartOption.getInstance()){

                public void run(ProgressIndicator indicator) {
                    MarkLocallyDeletedTreeConflictResolvedAction.this.resolveLocallyDeletedTextConflict(locallyDeletedChecker, (Ref<VcsException>)exception);
                }
            });
            if (!exception.isNull()) {
                AbstractVcsHelper.getInstance((Project)project).showError((VcsException)((Object)exception.get()), markText);
            }
        }
    }

    public void update(AnActionEvent e) {
        MyLocallyDeletedChecker locallyDeletedChecker = new MyLocallyDeletedChecker(e);
        e.getPresentation().setVisible(locallyDeletedChecker.isEnabled());
        e.getPresentation().setEnabled(locallyDeletedChecker.isEnabled());
    }

    private void resolveLocallyDeletedTextConflict(MyLocallyDeletedChecker checker, Ref<VcsException> exception) {
        FilePath path = checker.getPath();
        this.resolve(checker.getProject(), exception, path);
        VcsDirtyScopeManager.getInstance((Project)checker.getProject()).filePathsDirty(Collections.singletonList(path), null);
    }

    private void resolve(Project project, Ref<VcsException> exception, FilePath path) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        try {
            vcs.getFactory(path.getIOFile()).createConflictClient().resolve(path.getIOFile(), Depth.EMPTY, false, false, true);
        }
        catch (VcsException e) {
            exception.set((Object)e);
        }
    }

    private static class MyLocallyDeletedChecker {
        private final boolean myEnabled;
        private final FilePath myPath;
        private final Project myProject;

        public MyLocallyDeletedChecker(AnActionEvent e) {
            DataContext dc = e.getDataContext();
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dc);
            if (this.myProject == null) {
                this.myPath = null;
                this.myEnabled = false;
                return;
            }
            List missingFiles = (List)e.getData(ChangesListView.LOCALLY_DELETED_CHANGES);
            if (missingFiles == null || missingFiles.isEmpty()) {
                this.myPath = null;
                this.myEnabled = false;
                return;
            }
            LocallyDeletedChange change = (LocallyDeletedChange)missingFiles.get(0);
            this.myEnabled = change instanceof SvnLocallyDeletedChange && ((SvnLocallyDeletedChange)change).getConflictState().isTree();
            this.myPath = this.myEnabled ? change.getPath() : null;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

