/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.AddClient;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.RepositoryFeaturesClient;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.ImportClient;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.cleanup.CleanupClient;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.lock.LockClient;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.update.RelocateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;

public abstract class ClientFactory {
    protected SvnVcs myVcs;
    protected AddClient addClient;
    protected AnnotateClient annotateClient;
    protected ContentClient contentClient;
    protected HistoryClient historyClient;
    protected RevertClient revertClient;
    protected DeleteClient deleteClient;
    protected StatusClient statusClient;
    protected InfoClient infoClient;
    protected CopyMoveClient copyMoveClient;
    protected ConflictClient conflictClient;
    protected PropertyClient propertyClient;
    protected MergeClient mergeClient;
    protected ChangeListClient changeListClient;
    protected CheckoutClient checkoutClient;
    protected LockClient myLockClient;
    protected CleanupClient myCleanupClient;
    protected RelocateClient myRelocateClient;
    protected VersionClient myVersionClient;
    protected ImportClient myImportClient;
    protected ExportClient myExportClient;
    protected UpgradeClient myUpgradeClient;
    protected BrowseClient myBrowseClient;
    protected DiffClient myDiffClient;
    protected CheckinClient myCheckinClient;
    protected RepositoryFeaturesClient myRepositoryFeaturesClient;
    private final Map<Class, Class> myClientImplementations = ContainerUtil.newHashMap();

    protected ClientFactory(SvnVcs vcs) {
        this.myVcs = vcs;
        this.setup();
    }

    protected abstract void setup();

    protected <T extends SvnClient> void put(Class<T> type, Class<? extends T> implementation) {
        this.myClientImplementations.put(type, implementation);
    }

    protected <T extends SvnClient> Class<? extends T> get(Class<T> type) {
        Class implementation = this.myClientImplementations.get(type);
        if (implementation == null) {
            throw new IllegalArgumentException("No implementation registered for " + type);
        }
        return implementation;
    }

    public <T extends SvnClient> T create(Class<T> type, boolean isActive) {
        SvnClient client = this.prepare((SvnClient)ReflectionUtil.newInstance(this.get(type), (Class[])new Class[0]));
        client.setIsActive(isActive);
        return (T)client;
    }

    public AddClient createAddClient() {
        return this.prepare(this.addClient);
    }

    public AnnotateClient createAnnotateClient() {
        return this.prepare(this.annotateClient);
    }

    public ContentClient createContentClient() {
        return this.prepare(this.contentClient);
    }

    public HistoryClient createHistoryClient() {
        return this.prepare(this.historyClient);
    }

    public RevertClient createRevertClient() {
        return this.prepare(this.revertClient);
    }

    public StatusClient createStatusClient() {
        return this.prepare(this.statusClient);
    }

    public StatusClient createStatusClient(ISVNStatusFileProvider provider, ProgressTracker handler) {
        return this.createStatusClient();
    }

    public InfoClient createInfoClient() {
        return this.prepare(this.infoClient);
    }

    public abstract UpdateClient createUpdateClient();

    public DeleteClient createDeleteClient() {
        return this.prepare(this.deleteClient);
    }

    public CopyMoveClient createCopyMoveClient() {
        return this.prepare(this.copyMoveClient);
    }

    public ConflictClient createConflictClient() {
        return this.prepare(this.conflictClient);
    }

    public PropertyClient createPropertyClient() {
        return this.prepare(this.propertyClient);
    }

    public MergeClient createMergeClient() {
        return this.prepare(this.mergeClient);
    }

    public ChangeListClient createChangeListClient() {
        return this.prepare(this.changeListClient);
    }

    public CheckoutClient createCheckoutClient() {
        return this.prepare(this.checkoutClient);
    }

    public LockClient createLockClient() {
        return this.prepare(this.myLockClient);
    }

    public CleanupClient createCleanupClient() {
        return this.prepare(this.myCleanupClient);
    }

    public RelocateClient createRelocateClient() {
        return this.prepare(this.myRelocateClient);
    }

    public VersionClient createVersionClient() {
        return this.prepare(this.myVersionClient);
    }

    public ImportClient createImportClient() {
        return this.prepare(this.myImportClient);
    }

    public ExportClient createExportClient() {
        return this.prepare(this.myExportClient);
    }

    public UpgradeClient createUpgradeClient() {
        return this.prepare(this.myUpgradeClient);
    }

    public BrowseClient createBrowseClient() {
        return this.prepare(this.myBrowseClient);
    }

    public DiffClient createDiffClient() {
        return this.prepare(this.myDiffClient);
    }

    public CheckinClient createCheckinClient() {
        return this.prepare(this.myCheckinClient);
    }

    public RepositoryFeaturesClient createRepositoryFeaturesClient() {
        return this.prepare(this.myRepositoryFeaturesClient);
    }

    protected <T extends SvnClient> T prepare(T client) {
        client.setVcs(this.myVcs);
        client.setFactory(this);
        client.setIsActive(true);
        return client;
    }
}

