/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;

public enum Depth {
    UNKNOWN("unknown"),
    INFINITY("infinity"),
    IMMEDIATES("immediates"),
    FILES("files"),
    EMPTY("empty");

    private static final Map<String, Depth> ourAllDepths;
    private final String myName;

    private Depth(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(Depth depth) {
        ourAllDepths.put(depth.myName, depth);
    }

    public static Depth from(String depthName) {
        Depth result = ourAllDepths.get(depthName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown depth " + depthName);
        }
        return result;
    }

    public static Depth from(SVNDepth depth) {
        return depth != null ? Depth.from(depth.getName()) : UNKNOWN;
    }

    public static Depth allOrFiles(boolean recursive) {
        return recursive ? INFINITY : FILES;
    }

    public static Depth allOrEmpty(boolean recursive) {
        return recursive ? INFINITY : EMPTY;
    }

    public static boolean isRecursive(Depth depth) {
        return depth == null || depth == INFINITY || depth == UNKNOWN;
    }

    static {
        ourAllDepths = ContainerUtil.newHashMap();
        for (Depth action : Depth.values()) {
            Depth.register(action);
        }
    }
}

