/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.CertificateTrustManager;
import org.jetbrains.idea.svn.auth.SSLServerCertificateAuthenticator;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;

public class AuthenticationService {
    private final SvnVcs myVcs;
    private final boolean myIsActive;
    private static final Logger LOG = Logger.getInstance(AuthenticationService.class);
    private File myTempDirectory;
    private boolean myProxyCredentialsWereReturned;
    private SvnConfiguration myConfiguration;
    private final Set<String> myRequestedCredentials;

    public AuthenticationService(SvnVcs vcs, boolean isActive) {
        this.myVcs = vcs;
        this.myIsActive = isActive;
        this.myConfiguration = SvnConfiguration.getInstance(this.myVcs.getProject());
        this.myRequestedCredentials = ContainerUtil.newHashSet();
    }

    public SvnVcs getVcs() {
        return this.myVcs;
    }

    public File getTempDirectory() {
        return this.myTempDirectory;
    }

    public boolean isActive() {
        return this.myIsActive;
    }

    public SVNAuthentication requestCredentials(final SVNURL repositoryUrl, final String type) {
        SVNAuthentication authentication = null;
        if (repositoryUrl != null) {
            final String realm = repositoryUrl.toDecodedString();
            authentication = this.requestCredentials(realm, type, new Getter<SVNAuthentication>(){

                public SVNAuthentication get() {
                    return AuthenticationService.this.myVcs.getSvnConfiguration().getInteractiveManager(AuthenticationService.this.myVcs).getInnerProvider().requestClientAuthentication(type, repositoryUrl, realm, null, null, true);
                }
            });
        }
        if (authentication == null) {
            LOG.warn("Could not get authentication. Type - " + type + ", Url - " + repositoryUrl);
        }
        return authentication;
    }

    private <T> T requestCredentials(String realm, String type, Getter<T> fromUserProvider) {
        Object result = null;
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(type, realm);
        String key = SvnConfiguration.AuthStorage.getKey(type, realm);
        if (data != null && !this.myRequestedCredentials.contains(key)) {
            result = data;
            this.myRequestedCredentials.add(key);
        } else if (this.myIsActive && (result = fromUserProvider.get()) != null) {
            this.myVcs.getSvnConfiguration().acknowledge(type, realm, result);
            this.myRequestedCredentials.add(key);
        }
        return (T)result;
    }

    public String requestSshCredentials(final String realm, final SimpleCredentialsDialog.Mode mode, final String key) {
        return this.requestCredentials(realm, StringUtil.toLowerCase((String)mode.toString()), new Getter<String>(){

            public String get() {
                final Ref answer = new Ref();
                Runnable command = new Runnable(){

                    @Override
                    public void run() {
                        SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(AuthenticationService.this.myVcs.getProject());
                        dialog.setup(mode, realm, key, true);
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                        dialog.setSaveEnabled(false);
                        if (dialog.showAndGet()) {
                            answer.set((Object)dialog.getPassword());
                        }
                    }
                };
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)ModalityState.any());
                return (String)answer.get();
            }
        });
    }

    public AcceptResult acceptCertificate(SVNURL url, String certificateInfo) {
        AcceptResult result;
        String kind = "terminal.ssl.server";
        String realm = url.toDecodedString();
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(kind, realm);
        if (data != null) {
            result = (AcceptResult)((Object)data);
        } else {
            result = AcceptResult.from(this.getAuthenticationManager().getInnerProvider().acceptServerAuthentication(url, realm, (Object)certificateInfo, true));
            if (!AcceptResult.REJECTED.equals((Object)result)) {
                this.myVcs.getSvnConfiguration().acknowledge(kind, realm, (Object)result);
            }
        }
        return result;
    }

    public boolean acceptSSLServerCertificate(SVNURL repositoryUrl, String realm) throws SvnBindException {
        boolean result;
        if (repositoryUrl == null) {
            return false;
        }
        if (Registry.is((String)"svn.use.svnkit.for.https.server.certificate.check")) {
            result = new SSLServerCertificateAuthenticator(this, repositoryUrl, realm).tryAuthenticate();
        } else {
            HttpClient client = this.getClient(repositoryUrl);
            try {
                client.execute((HttpUriRequest)new HttpGet(repositoryUrl.toDecodedString()));
                result = true;
            }
            catch (IOException e) {
                throw new SvnBindException(AuthenticationService.fixMessage(e), e);
            }
        }
        return result;
    }

    private static String fixMessage(IOException e) {
        String message = null;
        if (e instanceof SSLHandshakeException) {
            if (StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"received fatal alert: handshake_failure")) {
                message = e.getMessage() + ". Please try to specify SSL protocol manually - SSLv3 or TLSv1";
            } else if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
        }
        return message;
    }

    private HttpClient getClient(SVNURL repositoryUrl) {
        SSLContext sslContext = this.createSslContext(repositoryUrl);
        List<String> supportedProtocols = this.getSupportedSslProtocols();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, ArrayUtil.toStringArray(supportedProtocols), null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        HttpConfigurable httpSettings = HttpConfigurable.getInstance();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.getAuthenticationManager().getReadTimeout(repositoryUrl)).build()).setDefaultRequestConfig(httpSettings.setProxy(RequestConfig.custom(), this.haveDataForTmpConfig()).setConnectTimeout(this.getAuthenticationManager().getConnectTimeout(repositoryUrl)).build()).setDefaultCredentialsProvider(httpSettings.setProxyCredentials((CredentialsProvider)new BasicCredentialsProvider(), this.haveDataForTmpConfig())).build();
    }

    private List<String> getSupportedSslProtocols() {
        ArrayList result = ContainerUtil.newArrayList();
        switch (this.myConfiguration.getSslProtocols()) {
            case sslv3: {
                result.add("SSLv3");
                break;
            }
            case tlsv1: {
                result.add("TLSv1");
                break;
            }
        }
        return result;
    }

    private SSLContext createSslContext(SVNURL url) {
        SSLContext result = CertificateManager.getSystemSslContext();
        CertificateTrustManager trustManager = new CertificateTrustManager(this, url);
        try {
            result.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public SvnAuthenticationManager getAuthenticationManager() {
        return this.isActive() ? this.myConfiguration.getInteractiveManager(this.myVcs) : this.myConfiguration.getPassiveAuthenticationManager(this.myVcs.getProject());
    }

    public void clearPassiveCredentials(String realm, SVNURL repositoryUrl, boolean password) {
        if (repositoryUrl == null) {
            return;
        }
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
        List<String> kinds = AuthenticationService.getKinds(repositoryUrl, password);
        for (String kind : kinds) {
            configuration.clearCredentials(kind, realm);
        }
    }

    public boolean haveDataForTmpConfig() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        return SvnConfiguration.getInstance(this.myVcs.getProject()).isIsUseDefaultProxy() && (instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC);
    }

    public static Proxy getIdeaDefinedProxy(SVNURL url) {
        CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        List proxies = CommonProxy.getInstance().select(URI.create(url.toString()));
        if (proxies != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                return proxy;
            }
        }
        return null;
    }

    public PasswordAuthentication getProxyAuthentication(SVNURL repositoryUrl) {
        Proxy proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl);
        PasswordAuthentication result = null;
        if (proxy != null) {
            if (this.myProxyCredentialsWereReturned) {
                AuthenticationService.showFailedAuthenticateProxy();
            } else {
                result = AuthenticationService.getProxyAuthentication(proxy, repositoryUrl);
                this.myProxyCredentialsWereReturned = result != null;
            }
        }
        return result;
    }

    private static void showFailedAuthenticateProxy() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        String message = instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC ? "Failed to authenticate to proxy. You can change proxy credentials in HTTP proxy settings." : "Failed to authenticate to proxy.";
        PopupUtil.showBalloonForActiveComponent((String)message, (MessageType)MessageType.ERROR);
    }

    private static PasswordAuthentication getProxyAuthentication(Proxy proxy, SVNURL repositoryUrl) {
        PasswordAuthentication result = null;
        try {
            result = Authenticator.requestPasswordAuthentication(repositoryUrl.getHost(), ((InetSocketAddress)proxy.address()).getAddress(), repositoryUrl.getPort(), repositoryUrl.getProtocol(), repositoryUrl.getHost(), repositoryUrl.getProtocol(), new URL(repositoryUrl.toString()), Authenticator.RequestorType.PROXY);
        }
        catch (MalformedURLException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    public void reset() {
        if (this.myTempDirectory != null) {
            FileUtil.delete((File)this.myTempDirectory);
        }
    }

    public static List<String> getKinds(SVNURL url, boolean passwordRequest) {
        if (passwordRequest || "http".equals(url.getProtocol())) {
            return Collections.singletonList("svn.simple");
        }
        if ("https".equals(url.getProtocol())) {
            return Collections.singletonList("svn.ssl.client-passphrase");
        }
        if ("svn".equals(url.getProtocol())) {
            return Collections.singletonList("svn.simple");
        }
        if (url.getProtocol().contains("svn+")) {
            return Arrays.asList("svn.ssh", "svn.username");
        }
        return Collections.singletonList("svn.username");
    }

    public File getSpecialConfigDir() {
        return this.myTempDirectory != null ? this.myTempDirectory : new File(this.myConfiguration.getConfigurationDirectory());
    }

    public void initTmpDir(SvnConfiguration configuration) throws IOException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = FileUtil.createTempDirectory((String)"tmp", (String)"Subversion");
            FileUtil.copyDir((File)new File(configuration.getConfigurationDirectory()), (File)this.myTempDirectory);
        }
    }
}

