/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.checkin.CommitEventType;
import org.tmatesoft.svn.core.SVNCancelException;

public class IdeaCommitHandler
implements CommitEventHandler,
ProgressTracker {
    private static final Logger LOG = Logger.getInstance(IdeaCommitHandler.class);
    private final ProgressIndicator myProgress;
    private final List<VirtualFile> myDeletedFiles = ContainerUtil.newArrayList();
    private final boolean myCheckCancel;
    private final boolean myTrackDeletedFiles;

    public IdeaCommitHandler(ProgressIndicator progress) {
        this(progress, false, false);
    }

    public IdeaCommitHandler(ProgressIndicator progress, boolean checkCancel, boolean trackDeletedFiles) {
        this.myProgress = progress;
        this.myCheckCancel = checkCancel;
        this.myTrackDeletedFiles = trackDeletedFiles;
    }

    public List<VirtualFile> getDeletedFiles() {
        return this.myDeletedFiles;
    }

    @Override
    public void commitEvent(CommitEventType type, File target) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.updateProgress(type, target.getPath());
    }

    @Override
    public void committedRevision(long revNum) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.myProgress.setText2(SvnBundle.message("status.text.comitted.revision", revNum));
    }

    public void consume(ProgressEvent event) {
        String path = event.getPath();
        if (path != null) {
            CommitEventType eventType = IdeaCommitHandler.convert(event.getAction());
            if (CommitEventType.deleting.equals((Object)eventType) && this.myTrackDeletedFiles) {
                this.trackDeletedFile(event);
            }
            this.updateProgress(eventType, path);
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        if (this.myCheckCancel && this.myProgress != null) {
            try {
                this.myProgress.checkCanceled();
            }
            catch (ProcessCanceledException ex) {
                throw new SVNCancelException();
            }
        }
    }

    private void updateProgress(CommitEventType type, String target) {
        if (this.myProgress == null) {
            return;
        }
        if (CommitEventType.adding.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.adding", target));
        } else if (CommitEventType.deleting.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.deleting", target));
        } else if (CommitEventType.sending.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.sending", target));
        } else if (CommitEventType.replacing.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.replacing", target));
        } else if (CommitEventType.transmittingDeltas.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.transmitting.delta", target));
        }
    }

    private void trackDeletedFile(ProgressEvent event) {
        final String filePath = "file://" + event.getFile().getAbsolutePath().replace(File.separatorChar, '/');
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(filePath);
            }
        });
        if (virtualFile != null) {
            this.myDeletedFiles.add(virtualFile);
        }
    }

    private static CommitEventType convert(EventAction action) {
        CommitEventType result = CommitEventType.unknown;
        if (EventAction.COMMIT_ADDED.equals((Object)action)) {
            result = CommitEventType.adding;
        } else if (EventAction.COMMIT_DELETED.equals((Object)action)) {
            result = CommitEventType.deleting;
        } else if (EventAction.COMMIT_MODIFIED.equals((Object)action)) {
            result = CommitEventType.sending;
        } else if (EventAction.COMMIT_REPLACED.equals((Object)action)) {
            result = CommitEventType.replacing;
        } else if (EventAction.COMMIT_DELTA_SENT.equals((Object)action)) {
            result = CommitEventType.transmittingDeltas;
        } else if (EventAction.SKIP.equals((Object)action)) {
            result = CommitEventType.skipped;
        } else if (EventAction.FAILED_OUT_OF_DATE.equals((Object)action)) {
            result = CommitEventType.failedOutOfDate;
        }
        if (CommitEventType.unknown.equals((Object)result)) {
            LOG.warn("Could not create commit event from action " + (Object)((Object)action));
        }
        return result;
    }
}

