/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.CertificateCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandParametersResolutionModule;
import org.jetbrains.idea.svn.commandLine.CommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.ProxyCallback;
import org.jetbrains.idea.svn.commandLine.ProxyModule;
import org.jetbrains.idea.svn.commandLine.SshTunnelRuntimeModule;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.TerminalExecutor;
import org.jetbrains.idea.svn.commandLine.TerminalSshModule;
import org.jetbrains.idea.svn.commandLine.TerminalSslCertificateModule;
import org.jetbrains.idea.svn.commandLine.TerminalUserNamePasswordModule;
import org.jetbrains.idea.svn.commandLine.TwoWaySslCallback;
import org.jetbrains.idea.svn.commandLine.UsernamePasswordCallback;
import org.jetbrains.idea.svn.commandLine.WinTerminalExecutor;
import org.tmatesoft.svn.core.SVNURL;

public class CommandRuntime {
    private static final Logger LOG = Logger.getInstance(CommandRuntime.class);
    private final AuthenticationService myAuthenticationService;
    private final SvnVcs myVcs;
    private final List<CommandRuntimeModule> myModules;
    private final String exePath;
    private final String executableLocale;

    public CommandRuntime(SvnVcs vcs, AuthenticationService authenticationService) {
        this.myVcs = vcs;
        this.myAuthenticationService = authenticationService;
        SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
        this.exePath = settings.getCommandLinePath();
        this.executableLocale = Registry.stringValue((String)"svn.executable.locale");
        this.myModules = ContainerUtil.newArrayList();
        this.myModules.add(new CommandParametersResolutionModule(this));
        this.myModules.add(new ProxyModule(this));
        this.myModules.add(new SshTunnelRuntimeModule(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandExecutor runWithAuthenticationAttempt(Command command) throws SvnBindException {
        try {
            this.onStart(command);
            boolean repeat = true;
            CommandExecutor executor = null;
            while (repeat) {
                executor = this.newExecutor(command);
                executor.run();
                repeat = this.onAfterCommand(executor, command);
            }
            CommandExecutor commandExecutor = executor;
            return commandExecutor;
        }
        finally {
            this.onFinish();
        }
    }

    public CommandExecutor runLocal(Command command, int timeout) throws SvnBindException {
        CommandExecutor executor = this.newExecutor(command);
        executor.run(timeout);
        this.onAfterCommand(executor, command);
        return executor;
    }

    private void onStart(Command command) throws SvnBindException {
        command.setCanceller(new SvnProgressCanceller());
        for (CommandRuntimeModule module : this.myModules) {
            module.onStart(command);
        }
    }

    private boolean onAfterCommand(CommandExecutor executor, Command command) throws SvnBindException {
        boolean repeat = false;
        Integer exitCode = executor.getExitCodeReference();
        if (exitCode == null || exitCode != 0) {
            CommandRuntime.logNullExitCode(executor, exitCode);
            this.cleanupManualDestroy(executor, command);
            repeat = !StringUtil.isEmpty((String)executor.getErrorOutput()) ? this.handleErrorText(executor, command) : CommandRuntime.handleErrorCode(executor);
        } else {
            CommandRuntime.handleSuccess(executor);
        }
        return repeat;
    }

    private static void handleSuccess(CommandExecutor executor) {
        if (!StringUtil.isEmptyOrSpaces((String)executor.getErrorOutput())) {
            LOG.info("Detected warning - " + executor.getErrorOutput());
        }
    }

    private static boolean handleErrorCode(CommandExecutor executor) throws SvnBindException {
        Integer exitCode = executor.getExitCodeReference();
        if (exitCode != null) {
            LOG.info("Command - " + executor.getCommandText());
            LOG.info("Command output - " + executor.getOutput());
            throw new SvnBindException("Svn process exited with error code: " + exitCode);
        }
        return false;
    }

    private boolean handleErrorText(CommandExecutor executor, Command command) throws SvnBindException {
        String errText = executor.getErrorOutput().trim();
        AuthCallbackCase callback = this.createCallback(errText, command.getRepositoryUrl(), executor instanceof TerminalExecutor);
        if (!executor.checkCancelled() && callback != null && callback.getCredentials(errText)) {
            if (this.myAuthenticationService.getSpecialConfigDir() != null) {
                command.setConfigDir(this.myAuthenticationService.getSpecialConfigDir());
            }
            callback.updateParameters(command);
            return true;
        }
        throw new SvnBindException(errText);
    }

    private void cleanupManualDestroy(CommandExecutor executor, Command command) throws SvnBindException {
        if (executor.isManuallyDestroyed()) {
            this.cleanup(executor, command.getWorkingDirectory());
            String destroyReason = executor.getDestroyReason();
            if (!StringUtil.isEmpty((String)destroyReason)) {
                throw new SvnBindException(destroyReason);
            }
        }
    }

    private void onFinish() {
        this.myAuthenticationService.reset();
    }

    private static void logNullExitCode(CommandExecutor executor, Integer exitCode) {
        if (exitCode == null) {
            LOG.info("Null exit code returned, but not errors detected " + executor.getCommandText());
        }
    }

    private AuthCallbackCase createCallback(final String errText, SVNURL url, boolean isUnderTerminal) {
        ArrayList authCases = ContainerUtil.newArrayList();
        if (isUnderTerminal) {
            authCases.add(new ProxyCallback(this.myAuthenticationService, url));
            authCases.add(new TwoWaySslCallback(this.myAuthenticationService, url));
        } else {
            authCases.add(new CertificateCallbackCase(this.myAuthenticationService, url));
            authCases.add(new ProxyCallback(this.myAuthenticationService, url));
            authCases.add(new TwoWaySslCallback(this.myAuthenticationService, url));
            authCases.add(new UsernamePasswordCallback(this.myAuthenticationService, url));
        }
        return (AuthCallbackCase)ContainerUtil.find((Iterable)authCases, (Condition)new Condition<AuthCallbackCase>(){

            public boolean value(AuthCallbackCase authCase) {
                return authCase.canHandle(errText);
            }
        });
    }

    private void cleanup(CommandExecutor executor, File workingDirectory) throws SvnBindException {
        if (executor.getCommandName().isWriteable()) {
            File wcRoot = SvnUtil.getWorkingCopyRootNew(workingDirectory);
            if (wcRoot != null) {
                Command cleanupCommand = new Command(SvnCommandName.cleanup);
                cleanupCommand.setWorkingDirectory(wcRoot);
                this.newExecutor(cleanupCommand).run();
            } else {
                LOG.info("Could not execute cleanup for command " + executor.getCommandText());
            }
        }
    }

    private CommandExecutor newExecutor(Command command) {
        CommandExecutor executor;
        if (!this.myVcs.getSvnConfiguration().isRunUnderTerminal() || CommandRuntime.isLocal(command)) {
            command.putIfNotPresent("--non-interactive");
            executor = new CommandExecutor(this.exePath, this.executableLocale, command);
        } else {
            executor = this.newTerminalExecutor(command);
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalSshModule(this, executor));
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalSslCertificateModule(this, executor));
            ((TerminalExecutor)executor).addInteractiveListener(new TerminalUserNamePasswordModule(this, executor));
        }
        return executor;
    }

    private TerminalExecutor newTerminalExecutor(Command command) {
        return SystemInfo.isWindows ? new WinTerminalExecutor(this.exePath, this.executableLocale, command) : new TerminalExecutor(this.exePath, this.executableLocale, command);
    }

    public static boolean isLocal(Command command) {
        return SvnCommandName.version.equals((Object)command.getName()) || SvnCommandName.cleanup.equals((Object)command.getName()) || SvnCommandName.add.equals((Object)command.getName()) || SvnCommandName.delete.equals((Object)command.getName()) || SvnCommandName.revert.equals((Object)command.getName()) || SvnCommandName.resolve.equals((Object)command.getName()) || SvnCommandName.upgrade.equals((Object)command.getName()) || SvnCommandName.changelist.equals((Object)command.getName()) || command.isLocalInfo() || command.isLocalStatus() || command.isLocalProperty() || command.isLocalCat();
    }

    public AuthenticationService getAuthenticationService() {
        return this.myAuthenticationService;
    }

    public SvnVcs getVcs() {
        return this.myVcs;
    }
}

