/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CommandUtil {
    public static void put(List<String> parameters, boolean condition, String value) {
        if (condition) {
            parameters.add(value);
        }
    }

    public static void put(List<String> parameters, File path) {
        CommandUtil.put(parameters, path.getAbsolutePath(), SVNRevision.UNDEFINED);
    }

    public static void put(List<String> parameters, File path, boolean usePegRevision) {
        if (usePegRevision) {
            CommandUtil.put(parameters, path);
        } else {
            parameters.add(path.getAbsolutePath());
        }
    }

    public static void put(List<String> parameters, File path, SVNRevision pegRevision) {
        CommandUtil.put(parameters, path.getAbsolutePath(), pegRevision);
    }

    public static void put(List<String> parameters, String path, SVNRevision pegRevision) {
        boolean hasPegRevision;
        StringBuilder builder = new StringBuilder(path);
        boolean hasAtSymbol = path.contains("@");
        boolean bl = hasPegRevision = pegRevision != null && !SVNRevision.UNDEFINED.equals((Object)pegRevision) && !SVNRevision.WORKING.equals((Object)pegRevision) && pegRevision.isValid();
        if (hasPegRevision || hasAtSymbol) {
            builder.append("@");
        }
        if (hasPegRevision) {
            builder.append(CommandUtil.format(pegRevision));
        }
        parameters.add(builder.toString());
    }

    public static void put(List<String> parameters, SvnTarget target) {
        CommandUtil.put(parameters, target.getPathOrUrlString(), target.getPegRevision());
    }

    public static void put(List<String> parameters, SvnTarget target, boolean usePegRevision) {
        if (usePegRevision) {
            CommandUtil.put(parameters, target);
        } else {
            parameters.add(target.getPathOrUrlString());
        }
    }

    public static void put(List<String> parameters, Depth depth) {
        CommandUtil.put(parameters, depth, false);
    }

    public static void put(List<String> parameters, Depth depth, boolean sticky) {
        if (depth != null && !Depth.UNKNOWN.equals((Object)depth)) {
            parameters.add("--depth");
            parameters.add(depth.getName());
            if (sticky) {
                parameters.add("--set-depth");
                parameters.add(depth.getName());
            }
        }
    }

    public static void put(List<String> parameters, SVNRevision revision) {
        if (revision != null && !SVNRevision.UNDEFINED.equals((Object)revision) && !SVNRevision.WORKING.equals((Object)revision) && revision.isValid()) {
            parameters.add("--revision");
            parameters.add(CommandUtil.format(revision));
        }
    }

    public static void put(List<String> parameters, SVNRevision startRevision, SVNRevision endRevision) {
        parameters.add("--revision");
        parameters.add(CommandUtil.format(startRevision) + ":" + CommandUtil.format(endRevision));
    }

    public static String format(SVNRevision revision) {
        return revision.getDate() != null ? "{" + DateFormatUtil.ISO8601_DATE_FORMAT.format(revision.getDate()) + "}" : revision.toString();
    }

    public static void put(List<String> parameters, DiffOptions diffOptions) {
        if (diffOptions != null) {
            String value;
            StringBuilder builder = new StringBuilder();
            if (diffOptions.isIgnoreAllWhitespace()) {
                builder.append(" --ignore-space-change");
            }
            if (diffOptions.isIgnoreAmountOfWhitespace()) {
                builder.append(" --ignore-all-space");
            }
            if (diffOptions.isIgnoreEOLStyle()) {
                builder.append(" --ignore-eol-style");
            }
            if (!StringUtil.isEmpty((String)(value = builder.toString().trim()))) {
                parameters.add("--extensions");
                parameters.add(value);
            }
        }
    }

    public static void putChangeLists(List<String> parameters, Iterable<String> changeLists) {
        if (changeLists != null) {
            for (String changeList : changeLists) {
                parameters.add("--cl");
                parameters.add(changeList);
            }
        }
    }

    public static String escape(String path) {
        return path.contains("@") ? path + "@" : path;
    }

    public static <T> T parse(String data, Class<T> type) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Reader)new StringReader(data.trim()));
    }

    public static File getHomeDirectory() {
        return new File(PathManager.getHomePath());
    }

    public static char getStatusChar(String type) {
        return !StringUtil.isEmpty((String)type) ? type.charAt(0) : (char)' ';
    }

    public static StatusType getStatusType(String type) {
        return CommandUtil.getStatusType(CommandUtil.getStatusChar(type));
    }

    public static StatusType getStatusType(char first) {
        StatusType contentsStatus = 'A' == first ? StatusType.STATUS_ADDED : ('D' == first ? StatusType.STATUS_DELETED : ('U' == first ? StatusType.CHANGED : ('C' == first ? StatusType.CONFLICTED : ('G' == first ? StatusType.MERGED : ('R' == first ? StatusType.STATUS_REPLACED : ('E' == first ? StatusType.STATUS_OBSTRUCTED : StatusType.STATUS_NORMAL))))));
        return contentsStatus;
    }

    public static File correctUpToExistingParent(File base) {
        while (base != null) {
            if (base.exists() && base.isDirectory()) {
                return base;
            }
            base = base.getParentFile();
        }
        return null;
    }
}

