/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessWrapper;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.commandLine.TerminalExecutor;
import org.jetbrains.idea.svn.commandLine.WinTerminalProcessHandler;

public class WinTerminalExecutor
extends TerminalExecutor {
    private static final int TERMINAL_WINDOW_MAX_COLUMNS = 480;
    private File myRedirectFile;
    private FileInputStream myRedirectStream;

    public WinTerminalExecutor(@NonNls String exePath, String locale, Command command) {
        super(exePath, locale, command);
    }

    @Override
    protected SvnProcessHandler createProcessHandler() {
        return new WinTerminalProcessHandler(this.myProcess, this.needsUtf8Output(), this.needsBinaryOutput());
    }

    @Override
    protected void beforeCreateProcess() throws SvnBindException {
        super.beforeCreateProcess();
        this.createRedirectFile();
    }

    private void createRedirectFile() throws SvnBindException {
        this.myRedirectFile = WinTerminalExecutor.createTempFile("terminal-output", "");
        try {
            this.myRedirectStream = new FileInputStream(this.myRedirectFile);
        }
        catch (FileNotFoundException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.deleteRedirectFile();
    }

    private void deleteRedirectFile() {
        if (this.myRedirectStream != null) {
            try {
                this.myRedirectStream.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        WinTerminalExecutor.deleteTempFile(this.myRedirectFile);
    }

    @Override
    protected Process createProcess() throws ExecutionException {
        this.checkRedirectFile();
        List<String> parameters = this.escapeArguments(this.buildParameters());
        parameters.add(0, ExecUtil.getWindowsShellName());
        parameters.add(1, "/c");
        parameters.add(">>");
        parameters.add(WinTerminalExecutor.quote(this.myRedirectFile.getAbsolutePath()));
        Process process = this.createProcess(parameters);
        return new ProcessWrapper(process){

            public InputStream getInputStream() {
                return WinTerminalExecutor.this.myRedirectStream;
            }

            public InputStream getErrorStream() {
                return this.getOriginalProcess().getInputStream();
            }
        };
    }

    private void checkRedirectFile() {
        if (this.myRedirectFile == null) {
            throw new IllegalStateException("No redirect file found");
        }
        if (this.myRedirectStream == null) {
            throw new IllegalStateException("No redirect stream found");
        }
    }

    @Override
    protected List<String> escapeArguments(List<String> arguments) {
        return ContainerUtil.map(arguments, (Function)new Function<String, String>(){

            public String fun(String argument) {
                return WinTerminalExecutor.needQuote(argument) && !WinTerminalExecutor.isQuoted(argument) ? WinTerminalExecutor.quote(argument) : argument;
            }
        });
    }

    private static String quote(String argument) {
        return StringUtil.wrapWithDoubleQuote((String)argument);
    }

    private static boolean needQuote(String argument) {
        return argument.contains(" ");
    }

    private static boolean isQuoted(String argument) {
        return StringUtil.startsWithChar((CharSequence)argument, (char)'\"') && StringUtil.endsWithChar((CharSequence)argument, (char)'\"');
    }

    static {
        if (SystemInfo.isWindows) {
            System.setProperty("win.pty.cols", String.valueOf(480));
        }
    }
}

