/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.idea.svn.dialogs.IterationResultHolder;

abstract class ByKeySelectedSearcher {
    private final String myKey;
    protected final List<TreeNode> myChildren;

    protected ByKeySelectedSearcher(String key, List<TreeNode> myChildren) {
        this.myKey = key;
        this.myChildren = myChildren;
    }

    protected abstract IterationResultHolder doChecks(TreeNode var1);

    public TreeNode getNextSelectedByKey() {
        if (this.myKey != null) {
            for (TreeNode node : this.myChildren) {
                IterationResultHolder checkResult = this.doChecks(node);
                if (IterationResultHolder.RESULT.equals((Object)checkResult)) {
                    return node;
                }
                if (IterationResultHolder.SKIP.equals((Object)checkResult) || this.myKey.compareTo(node.toString()) > 0) continue;
                return node;
            }
        }
        return this.myChildren == null || this.myChildren.isEmpty() ? null : this.myChildren.get(this.myChildren.size() - 1);
    }
}

