/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.ByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.FileByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.FolderByKeySelectedSearcher;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeRootNode;
import org.jetbrains.idea.svn.dialogs.SimpleTextNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class RepositoryTreeNode
implements TreeNode,
Disposable {
    private TreeNode myParentNode;
    private final List<TreeNode> myChildren;
    private final RepositoryTreeModel myModel;
    private final SVNURL myURL;
    private final Object myUserObject;
    private final NodeLoadState myLoadState;
    private NodeLoadState myChildrenLoadState;

    public RepositoryTreeNode(RepositoryTreeModel model, TreeNode parentNode, SVNURL url, Object userObject, NodeLoadState state) {
        this.myParentNode = parentNode;
        this.myURL = url;
        this.myModel = model;
        this.myUserObject = userObject;
        this.myLoadState = state;
        this.myChildren = ContainerUtil.newArrayList();
        this.myChildrenLoadState = NodeLoadState.EMPTY;
    }

    public RepositoryTreeNode(RepositoryTreeModel model, TreeNode parentNode, SVNURL url, Object userObject) {
        this(model, parentNode, url, userObject, NodeLoadState.REFRESHED);
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildren());
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getChildren().get(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public boolean isLeaf() {
        return this.myUserObject instanceof DirectoryEntry && ((DirectoryEntry)this.myUserObject).isFile();
    }

    @Override
    public TreeNode getParent() {
        return this.myParentNode;
    }

    public void reload(boolean removeCurrentChildren) {
        this.reload(removeCurrentChildren ? this.myModel.getSelectionKeepingExpander() : this.myModel.getLazyLoadingExpander(), removeCurrentChildren);
    }

    public TreeNode getNextChildByKey(String key, boolean isFolder) {
        ByKeySelectedSearcher searcher = isFolder ? new FolderByKeySelectedSearcher(key, this.myChildren) : new FileByKeySelectedSearcher(key, this.myChildren);
        return searcher.getNextSelectedByKey();
    }

    public String toString() {
        if (this.myParentNode instanceof RepositoryTreeRootNode) {
            return this.myURL.toString();
        }
        return SVNPathUtil.tail((String)this.myURL.getPath());
    }

    public void reload(Expander expander, boolean removeCurrentChildren) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (removeCurrentChildren || NodeLoadState.EMPTY.equals((Object)this.myChildrenLoadState)) {
            this.initChildren();
        }
        this.myModel.getCacheLoader().load(this, expander);
    }

    private void initChildren() {
        this.myChildren.clear();
        this.myChildren.add(new SimpleTextNode(CommonBundle.getLoadingTreeNodeText()));
        this.myChildrenLoadState = NodeLoadState.LOADING;
    }

    private List getChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (NodeLoadState.EMPTY.equals((Object)this.myChildrenLoadState)) {
            this.initChildren();
            this.myModel.getCacheLoader().load(this, this.myModel.getLazyLoadingExpander());
        }
        return this.myChildren;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public DirectoryEntry getSVNDirEntry() {
        return this.myUserObject instanceof DirectoryEntry ? (DirectoryEntry)this.myUserObject : null;
    }

    public void dispose() {
    }

    public TreeNode[] getSelfPath() {
        return this.myModel.getPathToRoot(this);
    }

    public boolean isRepositoryRoot() {
        return !(this.myUserObject instanceof DirectoryEntry);
    }

    public List<TreeNode> getAllAlreadyLoadedChildren() {
        return ContainerUtil.newArrayList(this.myChildren);
    }

    public List<RepositoryTreeNode> getAlreadyLoadedChildren() {
        return ContainerUtil.collect(this.myChildren.iterator(), (FilteringIterator.InstanceOf)FilteringIterator.instanceOf(RepositoryTreeNode.class));
    }

    public boolean isDisposed() {
        return this.myModel.isDisposed();
    }

    public void setChildren(List<DirectoryEntry> children, NodeLoadState state) {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        for (DirectoryEntry entry : children) {
            if (!this.myModel.isShowFiles() && !entry.isDirectory()) continue;
            nodes.add(new RepositoryTreeNode(this.myModel, this, entry.getUrl(), entry, state));
        }
        this.myChildrenLoadState = state;
        this.myChildren.clear();
        this.myChildren.addAll(nodes);
        this.myModel.reload(this);
    }

    public void setParentNode(TreeNode parentNode) {
        this.myParentNode = parentNode;
    }

    public void setAlienChildren(List<TreeNode> children, NodeLoadState oldState) {
        this.myChildren.clear();
        for (TreeNode child : children) {
            if (child instanceof RepositoryTreeNode) {
                ((RepositoryTreeNode)child).setParentNode(this);
                this.myChildren.add(child);
                this.myChildrenLoadState = oldState;
                continue;
            }
            if (!(child instanceof SimpleTextNode)) continue;
            SimpleTextNode node = (SimpleTextNode)child;
            this.myChildren.add(new SimpleTextNode(node.getText(), node.isError()));
            this.myChildrenLoadState = oldState;
        }
        this.myModel.reload(this);
    }

    public void setErrorNode(String text) {
        this.myChildren.clear();
        this.myChildren.add(new SimpleTextNode(text, true));
        this.myChildrenLoadState = NodeLoadState.ERROR;
        this.myModel.reload(this);
    }

    public SvnVcs getVcs() {
        return this.myModel.getVCS();
    }

    public boolean isCached() {
        return NodeLoadState.CACHED.equals((Object)this.myLoadState);
    }

    public RepositoryTreeNode getNodeWithSamePathUnderModelRoot() {
        return this.myModel.findByUrl(this);
    }

    public NodeLoadState getChildrenLoadState() {
        return this.myChildrenLoadState;
    }

    public void doOnSubtree(NotNullFunction<RepositoryTreeNode, Object> function) {
        new SubTreeWalker(this, function).execute();
    }

    private static class SubTreeWalker {
        private final RepositoryTreeNode myNode;
        private final NotNullFunction<RepositoryTreeNode, Object> myFunction;

        private SubTreeWalker(RepositoryTreeNode node, NotNullFunction<RepositoryTreeNode, Object> function) {
            this.myNode = node;
            this.myFunction = function;
        }

        public void execute() {
            this.executeImpl(this.myNode);
        }

        private void executeImpl(RepositoryTreeNode node) {
            this.myFunction.fun((Object)node);
            for (RepositoryTreeNode child : node.getAlreadyLoadedChildren()) {
                this.myFunction.fun((Object)child);
            }
        }
    }
}

