/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ThreadSafeTransparentlyFailedValue;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;

public abstract class RunOrContinuation<T, E extends Exception> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.dialogs.RunOrContinuation");
    protected final Project myProject;
    private final String myTaskTitle;
    private final Class<E> myClazzE;
    private volatile boolean myWasCanceled;
    private TransparentlyFailedValueI<T, E> myTransparentlyFailedValue;

    protected RunOrContinuation(Project project, String taskTitle, Class<E> clazzE) {
        this.myProject = project;
        this.myTaskTitle = taskTitle;
        this.myClazzE = clazzE;
        this.myTransparentlyFailedValue = new ThreadSafeTransparentlyFailedValue();
    }

    protected abstract T calculate() throws E;

    protected abstract T calculateLong() throws E;

    protected abstract void processResult(TransparentlyFailedValueI<T, E> var1);

    protected void cancel() {
        this.myWasCanceled = true;
    }

    private void setException(Exception e) {
        if (this.myClazzE.isAssignableFrom(e.getClass())) {
            this.myTransparentlyFailedValue.fail(e);
        } else {
            LOG.info((Throwable)e);
            this.myTransparentlyFailedValue.failRuntime(e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e));
        }
    }

    public TaskDescriptor getTask() {
        final TaskDescriptor pooled = new TaskDescriptor(this.myTaskTitle, Where.POOLED){

            public void run(ContinuationContext context) {
                try {
                    RunOrContinuation.this.myTransparentlyFailedValue.set(RunOrContinuation.this.calculateLong());
                }
                catch (Exception e) {
                    RunOrContinuation.this.setException(e);
                }
                if (!RunOrContinuation.this.myWasCanceled) {
                    context.next(new TaskDescriptor[]{new TaskDescriptor("final part", Where.AWT){

                        public void run(ContinuationContext context) {
                            RunOrContinuation.this.processResult(RunOrContinuation.this.myTransparentlyFailedValue);
                        }
                    }});
                }
            }
        };
        return new TaskDescriptor("short part", Where.AWT){

            public void run(ContinuationContext context) {
                try {
                    RunOrContinuation.this.myTransparentlyFailedValue.set(RunOrContinuation.this.calculate());
                }
                catch (Exception e) {
                    RunOrContinuation.this.setException(e);
                }
                if (!RunOrContinuation.this.myWasCanceled && RunOrContinuation.this.myTransparentlyFailedValue.haveSomething()) {
                    RunOrContinuation.this.processResult(RunOrContinuation.this.myTransparentlyFailedValue);
                    return;
                }
                context.next(new TaskDescriptor[]{pooled});
            }
        };
    }

    public void execute() {
        Continuation.createFragmented((Project)this.myProject, (boolean)true).run(new TaskDescriptor[]{this.getTask()});
    }
}

