/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class WCInfoWithBranches
extends WCInfo {
    private final List<Branch> myBranches;
    private final VirtualFile myRoot;
    private final Branch myCurrentBranch;

    public WCInfoWithBranches(WCInfo info, List<Branch> branches, VirtualFile root, Branch currentBranch) {
        super(info.getRootInfo(), info.isIsWcRoot(), info.getStickyDepth());
        this.myBranches = branches;
        this.myRoot = root;
        this.myCurrentBranch = currentBranch;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public VirtualFile getVcsRoot() {
        return this.myRoot;
    }

    public List<Branch> getBranches() {
        return this.myBranches;
    }

    public VirtualFile getRoot() {
        return this.myRoot;
    }

    public Branch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public static class Branch {
        private final String myName;
        private final String myUrl;

        public Branch(String url) {
            this.myName = SVNPathUtil.tail((String)url);
            this.myUrl = url;
        }

        public String getName() {
            return this.myName;
        }

        public String getUrl() {
            return this.myUrl;
        }

        public String toString() {
            return this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Branch branch = (Branch)o;
            return this.myUrl.equals(branch.myUrl);
        }

        public int hashCode() {
            return this.myUrl.hashCode();
        }
    }
}

